/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.client.render.entity;

import com.faboslav.variantsandventures.common.VariantsAndVentures;
import com.faboslav.variantsandventures.common.client.render.entity.feature.GelidOverlayFeatureRenderer;
import com.faboslav.variantsandventures.common.entity.mob.GelidEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.DrownedModel;
import net.minecraft.client.model.ZombieModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.AbstractZombieRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.ZombieRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class GelidEntityRenderer
extends AbstractZombieRenderer<GelidEntity, ZombieRenderState, DrownedModel> {
    private static final ResourceLocation TEXTURE = VariantsAndVentures.makeID("textures/entity/gelid/gelid.png");

    public GelidEntityRenderer(EntityRendererProvider.Context context) {
        super(context, (ZombieModel)new DrownedModel(context.bakeLayer(ModelLayers.DROWNED)), (ZombieModel)new DrownedModel(context.bakeLayer(ModelLayers.DROWNED_BABY)), (ZombieModel)new DrownedModel(context.bakeLayer(ModelLayers.DROWNED_INNER_ARMOR)), (ZombieModel)new DrownedModel(context.bakeLayer(ModelLayers.DROWNED_OUTER_ARMOR)), (ZombieModel)new DrownedModel(context.bakeLayer(ModelLayers.DROWNED_BABY_INNER_ARMOR)), (ZombieModel)new DrownedModel(context.bakeLayer(ModelLayers.DROWNED_BABY_OUTER_ARMOR)));
        this.addLayer(new GelidOverlayFeatureRenderer((RenderLayerParent<ZombieRenderState, DrownedModel>)this, context.getModelSet()));
    }

    public ZombieRenderState createRenderState() {
        return new ZombieRenderState();
    }

    @NotNull
    public ResourceLocation getTextureLocation(ZombieRenderState zombieRenderState) {
        return TEXTURE;
    }

    protected void setupRotations(ZombieRenderState zombieRenderState, PoseStack poseStack, float bodyRot, float scale) {
        super.setupRotations((LivingEntityRenderState)zombieRenderState, poseStack, bodyRot, scale);
        float h = zombieRenderState.swimAmount;
        if (h > 0.0f) {
            float i = -10.0f - zombieRenderState.xRot;
            float j = Mth.lerp((float)h, (float)0.0f, (float)i);
            poseStack.rotateAround(Axis.XP.rotationDegrees(j), 0.0f, zombieRenderState.boundingBoxHeight / 2.0f / scale, 0.0f);
        }
    }
}

