/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.sackman.entities.goals;

import de.cadentem.sackman.config.ServerConfig;
import de.cadentem.sackman.entities.SackManEntity;
import de.cadentem.sackman.entities.goals.Roll;
import de.cadentem.sackman.util.Utils;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;

public class SackManChaseGoal
extends Goal {
    private final SackManEntity sackMan;
    private final int maxSpeedReached;
    private final boolean followTargetEvenIfNotSeen;
    private long lastGameTimeCheck;
    private int ticksUntilLeave;
    private int ticksUntilNextAttack;
    private int speedUp;
    public int sackcooldown = 0;
    public static int dismountcooldown = 0;

    public SackManChaseGoal(SackManEntity sackMan, boolean followTargetEvenIfNotSeen) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.sackMan = sackMan;
        this.followTargetEvenIfNotSeen = followTargetEvenIfNotSeen;
        this.ticksUntilLeave = Utils.secondsToTicks((Integer)ServerConfig.TIME_UNTIL_LEAVE_CHASE.get());
        this.maxSpeedReached = Utils.secondsToTicks(3);
    }

    public static float updateRotation(float angle, float targetAngle, float maxIncrease) {
        float f = Mth.m_14177_((float)(targetAngle - angle));
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }

    public boolean m_8036_() {
        boolean canAttack;
        if (this.sackMan.m_20145_()) {
            return false;
        }
        if (this.sackMan.currentRoll != Roll.CHASE) {
            return false;
        }
        if (!this.sackMan.targetIsFacingMe) {
            return false;
        }
        long ticks = this.sackMan.f_19853_.m_46467_();
        if (ticks - this.lastGameTimeCheck < 20L) {
            return false;
        }
        this.lastGameTimeCheck = ticks;
        LivingEntity target = this.sackMan.m_5448_();
        if (!Utils.isValidPlayer((Entity)target)) {
            return false;
        }
        Path path = this.sackMan.m_21573_().m_6570_((Entity)target, 0);
        if (path != null) {
            return true;
        }
        boolean bl = canAttack = this.getAttackReachSqr(target) >= this.sackMan.m_20280_((Entity)target);
        if (canAttack) {
            return true;
        }
        path = this.sackMan.m_21573_().m_6570_((Entity)target, 0);
        return path != null;
    }

    public boolean m_8045_() {
        LivingEntity target = this.sackMan.m_5448_();
        if (!Utils.isValidPlayer((Entity)target)) {
            this.sackMan.disappear();
            return false;
        }
        if (!this.followTargetEvenIfNotSeen) {
            return !this.sackMan.m_21573_().m_26571_();
        }
        return this.sackMan.m_21444_(target.m_20183_());
    }

    public void m_8056_() {
        this.sackMan.m_21561_(true);
        this.ticksUntilNextAttack = 0;
    }

    public void m_8041_() {
        LivingEntity target = this.sackMan.m_5448_();
        if (!Utils.isValidPlayer((Entity)target)) {
            this.sackMan.m_6710_(null);
        }
        this.speedUp = 0;
        this.sackMan.m_21561_(false);
        this.sackMan.m_20088_().m_135381_(SackManEntity.CRAWLING_ACCESSOR, (Object)false);
        this.sackMan.m_21573_().m_26573_();
        this.sackMan.m_6210_();
    }

    public boolean m_183429_() {
        return true;
    }

    public static boolean canDismount() {
        return dismountcooldown <= 0;
    }

    public void m_8037_() {
        LivingEntity target = this.sackMan.m_5448_();
        --this.sackcooldown;
        System.out.println("dismounttick:" + --dismountcooldown);
        if (this.sackMan.m_20363_((Entity)target)) {
            double dx = this.sackMan.m_20185_() + 30.0;
            double dz = this.sackMan.m_20189_() + 30.0;
            Path path = this.sackMan.m_21573_().m_26524_(dx, 0.0, dz, 0);
            this.fixPath(path);
            this.sackMan.m_21573_().m_26536_(path, this.sackMan.getSpeedModifier());
            if (this.sackMan.f_19864_) {
                this.sackMan.m_20153_();
            }
        } else {
            boolean targetMoved;
            if (this.ticksUntilLeave <= 0 && !this.sackMan.targetIsFacingMe) {
                this.sackMan.disappear();
            }
            if (this.sackMan.m_20270_((Entity)target) < 2.0f && this.sackcooldown <= 0) {
                this.sackcooldown = 300;
                dismountcooldown = 100;
                target.m_20329_((Entity)this.sackMan);
                target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 90));
            }
            if (!Utils.isValidPlayer((Entity)target)) {
                return;
            }
            Path path = this.sackMan.m_21573_().m_26570_();
            this.fixPath(path);
            boolean bl = targetMoved = path != null && path.m_77395_() != null && path.m_77395_().m_164697_(target.m_20183_()) > 2.0f;
            if (path == null || this.sackMan.m_21573_().m_26577_() || targetMoved || path.m_77392_() && !this.shouldClimb(path) || this.sackMan.m_21573_().m_200903_(target.m_20183_()) && this.sackMan.f_19797_ % 20 == 0) {
                path = this.sackMan.m_21573_().m_6570_((Entity)target, 0);
                this.fixPath(path);
            }
            if (path != null && !path.m_77392_() && this.sackMan.m_142582_((Entity)target)) {
                this.sackMan.playChaseSound();
            }
            this.sackMan.m_21573_().m_26536_(path, this.sackMan.getSpeedModifier());
            if (!this.sackMan.isCrawling()) {
                if (this.sackMan.m_5912_()) {
                    this.sackMan.m_21563_().m_24960_((Entity)target, 90.0f, 90.0f);
                } else {
                    this.sackMan.m_21563_().m_24960_((Entity)target, 180.0f, 1.0f);
                }
            }
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            double distance = this.sackMan.m_20280_((Entity)target);
            this.checkAndPerformAttack(target, distance);
            --this.ticksUntilLeave;
            if (this.speedUp < this.maxSpeedReached) {
                ++this.speedUp;
            }
        }
    }

    private void fixPath(Path path) {
        LivingEntity target = this.sackMan.m_5448_();
        if (target == null) {
            return;
        }
        if (this.shouldClimb(path) && (double)path.m_77375_(0).m_164697_(this.sackMan.m_5448_().m_20183_()) > 0.1) {
            path.m_77377_(0, path.m_77375_(0).m_77289_(target.m_20183_().m_123341_(), target.m_20183_().m_123342_(), target.m_20183_().m_123343_()));
        }
    }

    private boolean shouldClimb(Path path) {
        if (this.sackMan.m_5448_() == null) {
            return false;
        }
        return path != null && path.m_77398_() == 1 && (float)this.sackMan.m_5448_().m_20183_().m_123342_() > (float)this.sackMan.m_20183_().m_123342_() + this.sackMan.getStepHeight();
    }

    private void checkAndPerformAttack(LivingEntity target, double distanceToTarget) {
        double attackReach = this.getAttackReachSqr(target);
        if (distanceToTarget <= attackReach && this.ticksUntilNextAttack <= 0) {
            this.resetAttackCooldown();
            this.sackMan.m_6674_(InteractionHand.MAIN_HAND);
            this.sackMan.m_7327_((Entity)target);
        }
    }

    private void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.m_183277_(20);
    }

    private double getAttackReachSqr(LivingEntity target) {
        return this.sackMan.m_20205_() * 4.0f * this.sackMan.m_20205_() * 4.0f + target.m_20205_();
    }
}

