/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.sackman.entities.goals;

import de.cadentem.sackman.entities.SackManEntity;
import de.cadentem.sackman.entities.goals.Roll;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class SackManFleeGoal
extends Goal {
    private final SackManEntity sackMan;
    private final double speedModifier;
    private float ticksUntilLeave;
    private float ticksUntilFlee;
    private boolean shouldLeave;
    private Path fleePath;
    private int ticksUntilNextPathRecalculation;

    public SackManFleeGoal(SackManEntity sackMan, float ticksUntilLeave, double speedModifier) {
        this.sackMan = sackMan;
        this.ticksUntilLeave = ticksUntilLeave;
        this.ticksUntilFlee = 10.0f;
        this.speedModifier = speedModifier;
    }

    public boolean m_8036_() {
        if (this.sackMan.m_20145_()) {
            return false;
        }
        if (this.sackMan.currentRoll != Roll.FLEE) {
            return false;
        }
        return this.sackMan.m_5448_() != null;
    }

    public boolean m_8045_() {
        if (this.sackMan.currentRoll != Roll.FLEE) {
            return false;
        }
        return this.sackMan.m_5448_() != null;
    }

    public void m_8056_() {
        this.setFleePath();
        this.shouldLeave = false;
    }

    public void m_8037_() {
        LivingEntity target = this.sackMan.m_5448_();
        if (this.shouldLeave && !this.sackMan.targetIsFacingMe) {
            this.sackMan.disappear();
        }
        this.ticksUntilFlee -= 1.0f;
        this.tickStareClock();
        if (this.ticksUntilFlee <= 0.0f) {
            this.fleeTick();
            this.sackMan.isFleeing = true;
            this.sackMan.m_20088_().m_135381_(SackManEntity.FLEEING_ACCESSOR, (Object)true);
        } else if (target != null) {
            this.sackMan.m_21563_().m_24960_((Entity)target, 180.0f, 1.0f);
        }
    }

    private void setFleePath() {
        LivingEntity target = this.sackMan.m_5448_();
        if (target == null) {
            return;
        }
        Vec3 fleePosition = DefaultRandomPos.m_148407_((PathfinderMob)this.sackMan, (int)32, (int)7, (Vec3)target.m_20182_());
        if (fleePosition != null) {
            this.fleePath = this.sackMan.m_21573_().m_26524_(fleePosition.f_82479_, fleePosition.f_82480_, fleePosition.f_82481_, 0);
        }
    }

    public void tickStareClock() {
        this.ticksUntilLeave -= 1.0f;
        if (this.ticksUntilLeave < 0.0f) {
            this.shouldLeave = true;
        }
    }

    public void fleeTick() {
        if (this.fleePath == null || this.fleePath.m_77392_()) {
            this.setFleePath();
        }
        this.sackMan.playFleeSound();
        this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
        if (this.ticksUntilNextPathRecalculation == 0) {
            this.ticksUntilNextPathRecalculation = 2;
            if (!this.sackMan.m_21573_().m_26536_(this.fleePath, this.speedModifier)) {
                this.ticksUntilNextPathRecalculation += 2;
            }
            this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
        }
    }
}

