/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.sackman.entities.goals;

import de.cadentem.sackman.entities.SackManEntity;
import de.cadentem.sackman.entities.goals.Roll;
import de.cadentem.sackman.util.Utils;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class SackManStareGoal
extends Goal {
    private final SackManEntity sackMan;
    private boolean wasNotLookingPreviously;
    private int lookedAtCount;
    private final int lookedAtMax;

    public SackManStareGoal(SackManEntity sackMan) {
        this.sackMan = sackMan;
        this.lookedAtMax = sackMan.m_217043_().m_216332_(8, 15);
    }

    public boolean m_8036_() {
        if (this.sackMan.m_20145_()) {
            return false;
        }
        if (!Utils.isValidPlayer((Entity)this.sackMan.m_5448_())) {
            return false;
        }
        return this.sackMan.currentRoll == Roll.STARE;
    }

    public boolean m_8045_() {
        if (!Utils.isValidPlayer((Entity)this.sackMan.m_5448_())) {
            return false;
        }
        return this.sackMan.currentRoll == Roll.STARE;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8041_() {
        super.m_8041_();
        this.lookedAtCount = 0;
        this.wasNotLookingPreviously = false;
        this.sackMan.pleaseStopMoving = false;
        this.sackMan.m_20088_().m_135381_(SackManEntity.SPOTTED_ACCESSOR, (Object)false);
    }

    public void m_8037_() {
        boolean actuallyLooking;
        LivingEntity target = this.sackMan.m_5448_();
        if (target == null) {
            this.sackMan.disappear();
            return;
        }
        boolean bl = actuallyLooking = this.sackMan.targetIsFacingMe && target.m_142582_((Entity)this.sackMan);
        if (this.wasNotLookingPreviously && actuallyLooking) {
            ++this.lookedAtCount;
        }
        if (this.lookedAtCount > this.lookedAtMax && !actuallyLooking) {
            if (this.sackMan.m_217043_().m_188500_() < 0.1) {
                this.sackMan.disappear();
            } else if (this.sackMan.m_217043_().m_188500_() < 0.3) {
                this.sackMan.pickRoll(List.of(Roll.CHASE, Roll.FLEE));
            }
        }
        if (!actuallyLooking) {
            this.sackMan.pleaseStopMoving = false;
            this.sackMan.m_21573_().m_5624_((Entity)target, 1.0);
        } else {
            this.sackMan.pleaseStopMoving = true;
            this.sackMan.m_21573_().m_26573_();
            this.sackMan.m_20256_(Vec3.f_82478_);
        }
        this.sackMan.m_21563_().m_148051_((Entity)target);
        this.wasNotLookingPreviously = !actuallyLooking;
    }
}

