/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.sackman.events;

import de.cadentem.sackman.SackMan;
import de.cadentem.sackman.config.ServerConfig;
import de.cadentem.sackman.entities.SackManEntity;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="sackman", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEvents {
    public static final ConcurrentHashMap<Integer, Integer> HIT_COUNTER = new ConcurrentHashMap();

    @SubscribeEvent
    public static void handleHurt(LivingAttackEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof SackManEntity) {
            boolean increaseCounter;
            SackManEntity sackMan = (SackManEntity)entity;
            boolean skipDamage = event.getSource() == DamageSource.f_19312_ || event.getSource() == DamageSource.f_19317_ || event.getSource() == DamageSource.f_19310_;
            boolean bl = increaseCounter = event.getSource() == DamageSource.f_19312_ || event.getSource() == DamageSource.f_19317_;
            if (skipDamage) {
                if (increaseCounter && !sackMan.f_19853_.m_5776_()) {
                    HIT_COUNTER.merge(sackMan.m_19879_(), 1, Integer::sum);
                    if (HIT_COUNTER.get(sackMan.m_19879_()) > 5) {
                        HIT_COUNTER.remove(sackMan.m_19879_());
                        boolean couldTeleport = sackMan.teleportToTarget();
                        sackMan.f_19864_ = true;
                        if (!couldTeleport) {
                            String key = sackMan.f_19853_.m_46472_().m_135782_().toString();
                            if (ServerConfig.isValidDimension(key)) {
                                int spawnDelta = (int)((double)((Integer)ServerConfig.CAN_SPAWN_MIN.get()).intValue() * 0.3);
                                int noiseDelta = (int)((double)((Integer)ServerConfig.RESET_NOISE_MIN.get()).intValue() * 0.3);
                                SackMan.speedUpTimers(key, spawnDelta, noiseDelta);
                            }
                            sackMan.disappear();
                        }
                    }
                }
                event.setCanceled(true);
            } else if (event.getSource() == DamageSource.f_19315_) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void handleDimensionChange(EntityTravelToDimensionEvent event) {
        SackMan.RELOAD_MISSING = true;
    }

    @SubscribeEvent
    public static void handleKnockback(LivingKnockBackEvent event) {
        SackManEntity sackMan;
        LivingEntity entity = event.getEntity();
        if (entity instanceof SackManEntity && (sackMan = (SackManEntity)entity).isClimbing()) {
            event.setCanceled(true);
        }
    }
}

