/*
 * Decompiled with CFR 0.152.
 */
package eu.pintergabor.oredetector.item;

import eu.pintergabor.oredetector.Global;
import eu.pintergabor.oredetector.config.ModConfig;
import eu.pintergabor.oredetector.mixinutil.DelayedExecute;
import eu.pintergabor.oredetector.sound.ModSounds;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public abstract class AbstractOreDetector
extends class_1792 {
    protected class_3414 bangs = null;
    protected float bangVolume = 1.0f;
    protected class_3218 clickWorld;
    protected class_2338 clickPos;
    protected class_2350 clickFacing;
    protected int distance;
    protected int type;
    protected class_3414 echoes;
    protected float echoVolume;
    protected int echoDelay;
    protected class_2394 particleEffect;
    protected int particleCount;

    public AbstractOreDetector(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1269 method_7884(class_1838 context) {
        if (!context.method_8045().method_8608()) {
            this.clickWorld = (class_3218)context.method_8045();
            this.clickPos = context.method_8037();
            this.clickFacing = context.method_8038();
            class_1657 player = context.method_8036();
            if (player != null) {
                if (((DelayedExecute)player).oredetector$isRunning()) {
                    return class_1269.field_5814;
                }
                if (!player.method_7337()) {
                    class_1799 stack = context.method_8041();
                    stack.method_7956(1, (class_1309)player, e -> e.method_20235(class_1304.field_6173));
                }
                this.clickWorld.method_8396(null, this.clickPos, this.bangs, class_3419.field_15245, this.bangVolume, 1.0f);
                if (this.scan()) {
                    ((DelayedExecute)player).oredetector$delayedExecute(this.echoDelay, () -> {
                        this.clickWorld.method_8396(null, this.clickPos, this.echoes, class_3419.field_15245, this.echoVolume, 1.0f);
                        class_2338 ppos = this.clickPos.method_10093(this.clickFacing);
                        if (this.particleEffect != null) {
                            this.clickWorld.method_14199(this.particleEffect, (double)ppos.method_10263() + 0.5, (double)ppos.method_10264() + 0.5, (double)ppos.method_10260() + 0.5, this.particleCount, 0.0, 0.0, 0.0, 1.0);
                        }
                    });
                }
            }
        }
        return class_1269.field_5812;
    }

    protected abstract int getRange();

    protected abstract boolean detect(class_2338 var1, int var2);

    private boolean priDetect(class_2338 pos, int distance) {
        boolean ret = this.detect(pos, distance);
        ModConfig config = ModConfig.getInstance();
        if (0 < config.debugLevel && ret) {
            Global.LOGGER.info("Found: {}, type: {}, at ({})", new Object[]{this.clickWorld.method_8320(pos).method_26204().toString(), this.type, pos.method_10059((class_2382)this.clickPos).method_23854()});
        }
        if (1 < config.debugLevel && !ret) {
            this.clickWorld.method_8652(pos, class_2246.field_10033.method_9564(), 3);
        }
        return ret;
    }

    private class_2382 translate(int x, int y, int z) {
        return switch (this.clickFacing) {
            default -> new class_2382(x, y, z);
            case class_2350.field_11033 -> new class_2382(-x, -y, z);
            case class_2350.field_11034 -> new class_2382(y, -x, z);
            case class_2350.field_11039 -> new class_2382(-y, x, z);
            case class_2350.field_11043 -> new class_2382(x, z, -y);
            case class_2350.field_11035 -> new class_2382(x, z, y);
        };
    }

    private boolean transDetect(int x, int y, int z, int d) {
        return this.priDetect(this.clickPos.method_10081(this.translate(x, y, z)), d);
    }

    private boolean transDetect4(int x, int y, int z, int d) {
        return this.transDetect(x, y, z, d) || this.transDetect(z, y, -x, d) || this.transDetect(-x, y, -z, d) || this.transDetect(-z, y, x, d);
    }

    protected boolean scan() {
        int range = this.getRange();
        for (int d = 0; d < range; ++d) {
            if (this.transDetect(0, -d, 0, d)) {
                return true;
            }
            for (int y = 0; y < d; ++y) {
                if ((d - y & 1) != 0) continue;
                int n = (d - y) / 2;
                for (int x = 0; x < n; ++x) {
                    if (!this.transDetect4(x, -y, n - x, d)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected void calcEcho(int type, int distance) {
        this.type = type;
        this.distance = distance;
        this.echoes = ModSounds.DETECTOR_3ECHOS[type];
        this.echoVolume = 1.0f - 0.9f * (float)distance / (float)this.getRange();
        this.echoDelay = 10 + 2 * distance;
        this.particleEffect = null;
    }

    protected void calcEcho(int type, int distance, class_2248 pBlock) {
        this.calcEcho(type, distance);
        ModConfig config = ModConfig.getInstance();
        if (config.enableParticles) {
            this.particleEffect = new class_2388(class_2398.field_11217, pBlock.method_9564());
            this.particleCount = (int)(40.0f * (1.0f - 0.9f * (float)distance / (float)this.getRange()));
        }
    }
}

