/*
 * Decompiled with CFR 0.152.
 */
package eu.pintergabor.oredetector.config;

import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import org.jetbrains.annotations.ApiStatus;

@Config(name="oredetector")
@ApiStatus.Internal
public class ModConfig
implements ConfigData {
    @ConfigEntry.Gui.Tooltip
    public boolean enableVoidDetector = true;
    @ConfigEntry.Gui.Tooltip
    public int rangeVoidDetector = 10;
    @ConfigEntry.Gui.Tooltip
    public int durabilityVoidDetector = 100;
    @ConfigEntry.Gui.Tooltip
    public boolean enableCoalDetector = true;
    @ConfigEntry.Gui.Tooltip
    public int rangeCoalDetector = 9;
    @ConfigEntry.Gui.Tooltip
    public int durabilityCoalDetector = 100;
    @ConfigEntry.Gui.Tooltip
    public boolean enableIronDetector = true;
    @ConfigEntry.Gui.Tooltip
    public int rangeIronDetector = 10;
    @ConfigEntry.Gui.Tooltip
    public int durabilityIronDetector = 150;
    @ConfigEntry.Gui.Tooltip
    public boolean enableGoldDetector = true;
    @ConfigEntry.Gui.Tooltip
    public int rangeGoldDetector = 11;
    @ConfigEntry.Gui.Tooltip
    public int durabilityGoldDetector = 200;
    @ConfigEntry.Gui.Tooltip
    public boolean enableDiamondDetector = true;
    @ConfigEntry.Gui.Tooltip
    public int rangeDiamondDetector = 12;
    @ConfigEntry.Gui.Tooltip
    public int durabilityDiamondDetector = 250;
    public boolean enableParticles = true;
    @ConfigEntry.Gui.Excluded
    public int debugLevel = 0;

    public static void init() {
        AutoConfig.register(ModConfig.class, GsonConfigSerializer::new);
    }

    public static ModConfig getInstance() {
        return (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
    }

    public void validatePostLoad() {
        this.rangeVoidDetector = Math.min(Math.max(1, this.rangeVoidDetector), 16);
        this.durabilityVoidDetector = Math.min(Math.max(1, this.durabilityVoidDetector), 999);
        this.rangeCoalDetector = Math.min(Math.max(1, this.rangeCoalDetector), 16);
        this.durabilityCoalDetector = Math.min(Math.max(1, this.durabilityCoalDetector), 999);
        this.rangeIronDetector = Math.min(Math.max(1, this.rangeIronDetector), 16);
        this.durabilityIronDetector = Math.min(Math.max(1, this.durabilityIronDetector), 999);
        this.rangeGoldDetector = Math.min(Math.max(1, this.rangeGoldDetector), 16);
        this.durabilityGoldDetector = Math.min(Math.max(1, this.durabilityGoldDetector), 999);
        this.rangeDiamondDetector = Math.min(Math.max(1, this.rangeDiamondDetector), 16);
        this.durabilityDiamondDetector = Math.min(Math.max(1, this.durabilityDiamondDetector), 999);
    }
}

