/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.starcaller;

import folk.sisby.starcaller.Star;
import folk.sisby.starcaller.Starcaller;
import folk.sisby.starcaller.util.StarUtil;
import java.util.List;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class StarState
extends class_18 {
    public static final String KEY_SEED = "seed";
    public static final String KEY_LIMIT = "limit";
    public static final String KEY_STARS = "stars";
    public long seed;
    public int limit;
    public int iterations;
    public List<Star> stars;

    public static class_18.class_8645<StarState> getPersistentStateType(long worldSeed) {
        return new class_18.class_8645(() -> new StarState(worldSeed), nbt -> StarState.fromNbt(nbt, worldSeed), null);
    }

    public StarState(long worldSeed) {
        this.seed = Starcaller.CONFIG.starSeed != -1L ? Starcaller.CONFIG.starSeed : worldSeed;
        this.limit = Starcaller.CONFIG.starLimit;
        this.iterations = StarUtil.getGeneratorIterations(this.seed, this.limit);
        this.stars = StarUtil.generateStars(this.seed, this.iterations);
        this.method_80();
    }

    public StarState(long seed, int limit, int iterations, List<Star> stars) {
        this.seed = seed;
        this.limit = limit;
        this.iterations = iterations;
        this.stars = stars;
    }

    public static StarState fromNbt(class_2487 nbt, long worldSeed) {
        long seed = nbt.method_10545(KEY_SEED) ? nbt.method_10537(KEY_SEED) : (Starcaller.CONFIG.starSeed != -1L ? Starcaller.CONFIG.starSeed : worldSeed);
        int limit = nbt.method_10545(KEY_LIMIT) ? nbt.method_10550(KEY_LIMIT) : Starcaller.CONFIG.starLimit.intValue();
        int iterations = StarUtil.getGeneratorIterations(seed, limit);
        List<Star> stars = StarUtil.generateStars(seed, iterations);
        int i = 0;
        for (class_2520 starElement : nbt.method_10554(KEY_STARS, 10)) {
            if (i < stars.size() && starElement instanceof class_2487) {
                class_2487 starCompound = (class_2487)starElement;
                stars.get(i).readNbt(starCompound);
            }
            ++i;
        }
        return new StarState(seed, limit, iterations, stars);
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2499 nbtList = new class_2499();
        for (Star star : this.stars) {
            nbtList.add((Object)star.toNbt());
        }
        nbt.method_10544(KEY_SEED, this.seed);
        nbt.method_10569(KEY_LIMIT, this.limit);
        nbt.method_10566(KEY_STARS, (class_2520)nbtList);
        return nbt;
    }
}

