/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.starcaller;

import folk.sisby.starcaller.Star;
import folk.sisby.starcaller.StarState;
import folk.sisby.starcaller.StarcallerConfig;
import folk.sisby.starcaller.StarcallerNetworking;
import folk.sisby.starcaller.StardustTicker;
import folk.sisby.starcaller.duck.StarcallerWorld;
import folk.sisby.starcaller.item.SpearItem;
import folk.sisby.starcaller.item.StardustItem;
import java.nio.file.Path;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5251;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Starcaller
implements ModInitializer {
    public static final String ID = "starcaller";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"starcaller");
    public static final String STATE_KEY = "starcaller_stars";
    public static final StardustItem STARDUST = (StardustItem)((Object)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)Starcaller.id("stardust"), (Object)((Object)new StardustItem((class_1792.class_1793)new FabricItemSettings().maxCount(1)))));
    public static final SpearItem SPEAR = (SpearItem)((Object)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)Starcaller.id("spear"), (Object)((Object)new SpearItem((class_1792.class_1793)new FabricItemSettings().maxCount(1)))));
    public static final StarcallerConfig CONFIG = (StarcallerConfig)StarcallerConfig.createToml((Path)FabricLoader.getInstance().getConfigDir(), (String)"", (String)"starcaller", StarcallerConfig.class);
    public static StardustTicker TICKER = new StardustTicker(){};

    public void onInitialize() {
        ServerWorldEvents.LOAD.register((server, world) -> {
            if (world.method_27983() == class_1937.field_25179) {
                world.method_17983().method_17924(StarState.getPersistentStateType(world.method_8412()), STATE_KEY);
            }
        });
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            for (Star star : ((StarcallerWorld)world).starcaller$getStars()) {
                if (world.method_8510() <= star.groundedTick + (long)Starcaller.CONFIG.starGroundedTicks.intValue()) continue;
                star.groundedTick = -1L;
            }
        });
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41060).register(entries -> entries.addBefore((class_1935)class_1802.field_8884, new class_1935[]{SPEAR}));
        StarcallerNetworking.init();
        LOGGER.info("[Starcaller] Initialized.");
    }

    public static class_2960 id(String path) {
        return new class_2960(ID, path);
    }

    public static void groundStar(class_1657 cause, class_3218 world, Star star) {
        Starcaller.updateStarGrounded(cause, world, star, world.method_8510());
    }

    public static void freeStar(class_1657 cause, class_3218 world, Star star) {
        Starcaller.updateStarGrounded(cause, world, star, -1L);
    }

    private static void updateStarGrounded(class_1657 cause, class_3218 world, Star star, long time) {
        if (star.groundedTick != time) {
            star.groundedTick = time;
            ((StarState)world.method_17983().method_20786(StarState.getPersistentStateType(world.method_8412()), STATE_KEY)).method_80();
            StarcallerNetworking.syncStarGrounded(cause, world, star);
        }
    }

    public static void colorStar(class_1657 cause, class_3218 world, Star star, int color) {
        if (star.color != color) {
            star.color = color;
            StarcallerNetworking.syncStarColor(cause, world, star);
        }
        class_5251 nameColor = cause.method_5476().method_10866().method_10973();
        star.editor = cause.method_5476().getString();
        star.editorColor = nameColor != null ? nameColor.method_27716() : 0xFFFFFF;
        ((StarState)world.method_17983().method_20786(StarState.getPersistentStateType(world.method_8412()), STATE_KEY)).method_80();
    }
}

