/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.starcaller;

import folk.sisby.starcaller.Star;
import folk.sisby.starcaller.Starcaller;
import folk.sisby.starcaller.duck.StarcallerWorld;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.Map;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class StarcallerNetworking {
    public static final class_2960 S2C_INITIAL_STAR_STATE = Starcaller.id("initial_star_state");
    public static final class_2960 S2C_UPDATE_GROUNDED = Starcaller.id("update_grounded");
    public static final class_2960 S2C_UPDATE_COLORS = Starcaller.id("update_colors");

    public static void init() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> StarcallerNetworking.sendInitialStarState(handler.field_14140));
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> StarcallerNetworking.sendInitialStarState(player));
    }

    public static void sendInitialStarState(class_3222 player) {
        class_3218 world = player.method_51469();
        if (world.method_27983() == class_1937.field_25179) {
            Int2ObjectArrayMap groundedMap = new Int2ObjectArrayMap();
            Int2ObjectArrayMap colorMap = new Int2ObjectArrayMap();
            for (Star star : ((StarcallerWorld)world).starcaller$getStars()) {
                if (groundedMap.isEmpty() || star.groundedTick != -1L) {
                    groundedMap.put(((StarcallerWorld)world).starcaller$getStars().indexOf(star), star.groundedTick);
                }
                if (!colorMap.isEmpty() && star.color == -1) continue;
                colorMap.put(((StarcallerWorld)world).starcaller$getStars().indexOf(star), star.color);
            }
            class_2540 stateBuf = PacketByteBufs.create();
            stateBuf.method_52974(((StarcallerWorld)world).starcaller$getSeed());
            stateBuf.method_53002(((StarcallerWorld)world).starcaller$getIterations());
            stateBuf.method_34063((Map)groundedMap, class_2540::method_53002, class_2540::method_52974);
            stateBuf.method_34063((Map)colorMap, class_2540::method_53002, class_2540::method_53002);
            ServerPlayNetworking.send((class_3222)player, (class_2960)S2C_INITIAL_STAR_STATE, (class_2540)stateBuf);
        }
    }

    public static void syncStarGrounded(class_1657 cause, class_3218 world, Star star) {
        int starIndex = ((StarcallerWorld)world).starcaller$getStars().indexOf(star);
        Map<Integer, Long> groundedMap = Map.of(starIndex, star.groundedTick);
        class_2540 buf = PacketByteBufs.create();
        buf.method_34063(groundedMap, class_2540::method_53002, class_2540::method_52974);
        for (class_3222 player : world.method_18456()) {
            if (player == cause) continue;
            ServerPlayNetworking.send((class_3222)player, (class_2960)S2C_UPDATE_GROUNDED, (class_2540)buf);
        }
    }

    public static void syncStarColor(class_1657 cause, class_3218 world, Star star) {
        int starIndex = ((StarcallerWorld)world).starcaller$getStars().indexOf(star);
        Map<Integer, Integer> colorMap = Map.of(starIndex, star.color);
        class_2540 buf = PacketByteBufs.create();
        buf.method_34063(colorMap, class_2540::method_53002, class_2540::method_53002);
        for (class_3222 player : world.method_18456()) {
            if (player == cause) continue;
            ServerPlayNetworking.send((class_3222)player, (class_2960)S2C_UPDATE_COLORS, (class_2540)buf);
        }
    }
}

