/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.starcaller.client;

import folk.sisby.starcaller.Star;
import folk.sisby.starcaller.Starcaller;
import folk.sisby.starcaller.client.StarcallerClientNetworking;
import folk.sisby.starcaller.client.StardustTickerImpl;
import folk.sisby.starcaller.duck.StarcallerWorld;
import folk.sisby.starcaller.item.StardustItem;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5251;
import net.minecraft.class_5272;
import net.minecraft.class_638;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarcallerClient
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"starcaller_client");
    public static final class_2960 CROSSHAIR_TEXTURE = Starcaller.id("hud/crosshair");
    public static Random random = new Random();

    public void onInitializeClient() {
        class_5272.method_27879((class_1792)Starcaller.SPEAR, (class_2960)new class_2960("throwing"), (stack, world, entity, i) -> entity != null && entity.method_6115() && entity.method_6030() == stack ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)Starcaller.STARDUST, (class_2960)new class_2960("star_expired"), (stack, world, entity, i) -> Objects.requireNonNullElse(StardustItem.getRemainingTicks(stack, (class_1937)world), 1L) <= 0L ? 1.0f : 0.0f);
        ColorProviderRegistry.ITEM.register((stack, index) -> index > 0 ? 0x888888 + random.nextInt(127) : -1, (Object[])new class_1935[]{Starcaller.SPEAR});
        ColorProviderRegistry.ITEM.register((stack, index) -> stack.method_31580(), (Object[])new class_1935[]{Starcaller.STARDUST});
        ClientTickEvents.END_WORLD_TICK.register(StarcallerClient::clientTick);
        StarcallerClientNetworking.init();
        Starcaller.TICKER = new StardustTickerImpl();
        LOGGER.info("[Starcaller Client] Initialized.");
    }

    public static void groundStar(class_638 world, Star star) {
        star.groundedTick = world.method_8510();
        StarcallerClient.reloadStars(world);
    }

    public static void freeStar(class_638 world, Star star) {
        star.groundedTick = -1L;
        StarcallerClient.reloadStars(world);
    }

    public static void colorStar(class_1657 cause, class_638 world, Star star, int color) {
        star.color = color;
        class_5251 nameColor = cause.method_5476().method_10866().method_10973();
        star.editor = cause.method_5476().getString();
        star.editorColor = nameColor != null ? nameColor.method_27716() : 0xFFFFFF;
        StarcallerClient.reloadStars(world);
    }

    public static void reloadStars(class_638 world) {
        class_310.method_1551().execute(() -> {
            if (world.field_17780.field_4113 != null) {
                world.field_17780.method_3293();
            }
        });
    }

    private static void clientTick(class_638 world) {
        if (world instanceof StarcallerWorld) {
            StarcallerWorld scw = (StarcallerWorld)world;
            List<Star> stars = scw.starcaller$getStars();
            boolean reloadStars = false;
            for (Star star : stars) {
                if (star.groundedTick + (long)Starcaller.CONFIG.starGroundedTicks.intValue() > world.method_8510()) continue;
                star.groundedTick = -1L;
                reloadStars = true;
            }
            if (reloadStars) {
                StarcallerClient.reloadStars(world);
            }
        }
    }
}

