/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.starcaller.item;

import com.unascribed.lib39.sandman.api.TicksAlwaysItem;
import folk.sisby.starcaller.Star;
import folk.sisby.starcaller.Starcaller;
import folk.sisby.starcaller.duck.StarcallerWorld;
import folk.sisby.starcaller.util.ColorUtil;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1768;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import org.jetbrains.annotations.Nullable;

public class StardustItem
extends class_1792
implements class_1768,
TicksAlwaysItem {
    public static final String KEY_STAR_INDEX = "star";
    public static final String KEY_STAR_GROUNDED_TICK = "groundedTick";
    public static final String KEY_EDITOR = "editor";
    public static final String KEY_EDITOR_COLOR = "editorColor";

    public StardustItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public static class_1799 fromStar(int index, Star star) {
        class_1799 stack = Starcaller.STARDUST.method_7854().method_7972();
        class_2487 nbt = stack.method_7948();
        nbt.method_10569(KEY_STAR_INDEX, index);
        nbt.method_10544(KEY_STAR_GROUNDED_TICK, star.groundedTick);
        class_2487 display = new class_2487();
        display.method_10569("color", star.color);
        nbt.method_10566("display", (class_2520)display);
        if (star.editor != null) {
            nbt.method_10582(KEY_EDITOR, star.editor);
        }
        nbt.method_10569(KEY_EDITOR_COLOR, star.editorColor);
        return stack;
    }

    @Nullable
    public static Integer getStarIndex(class_1799 stack) {
        return stack.method_7969() != null && stack.method_7969().method_10545(KEY_STAR_INDEX) ? Integer.valueOf(stack.method_7969().method_10550(KEY_STAR_INDEX)) : null;
    }

    @Nullable
    public static Long getGroundedTick(class_1799 stack) {
        return stack.method_7969() != null && stack.method_7969().method_10545(KEY_STAR_GROUNDED_TICK) ? Long.valueOf(stack.method_7969().method_10537(KEY_STAR_GROUNDED_TICK)) : null;
    }

    @Nullable
    public static class_5250 getEditor(class_1799 stack) {
        return stack.method_7969() != null && stack.method_7969().method_10545(KEY_EDITOR) && stack.method_7969().method_10545(KEY_EDITOR_COLOR) ? class_2561.method_43470((String)stack.method_7969().method_10558(KEY_EDITOR)).method_10862(class_2583.field_24360.method_36139(stack.method_7969().method_10550(KEY_EDITOR_COLOR))) : null;
    }

    @Nullable
    public static Star getStar(class_1799 stack, class_1937 world) {
        Integer starIndex = StardustItem.getStarIndex(stack);
        if (world instanceof StarcallerWorld) {
            StarcallerWorld scw = (StarcallerWorld)world;
            if (starIndex != null) {
                List<Star> stars = scw.starcaller$getStars();
                if (starIndex < stars.size()) {
                    return stars.get(starIndex);
                }
            }
        }
        return null;
    }

    @Nullable
    public static Long getRemainingTicks(class_1799 stack, class_1937 world) {
        Long groundedTick = StardustItem.getGroundedTick(stack);
        return world != null && groundedTick != null ? Long.valueOf((long)Starcaller.CONFIG.starGroundedTicks.intValue() + groundedTick - world.method_8510()) : null;
    }

    @Nullable
    public static Long getWorldRemainingTicks(class_1799 stack, class_1937 world) {
        Star star = StardustItem.getStar(stack, world);
        return star != null ? Long.valueOf((long)Starcaller.CONFIG.starGroundedTicks.intValue() + star.groundedTick - world.method_8510()) : null;
    }

    public static class_2561 getCountdown(long remainingTicks) {
        return class_2561.method_43469((String)"item.starcaller.stardust.countdown", (Object[])new Object[]{class_2561.method_43470((String)String.valueOf((int)Math.ceil((float)remainingTicks / 20.0f))).method_27692(class_124.field_1065)}).method_27692(class_124.field_1063);
    }

    public class_2561 method_7864(class_1799 stack) {
        class_5250 name = super.method_7864(stack).method_27661();
        Integer starIndex = StardustItem.getStarIndex(stack);
        if (starIndex != null) {
            name = class_2561.method_43471((String)"star.starcaller.overworld.%s".formatted(starIndex)).method_27692(class_124.field_1056);
        }
        if (this.method_7801(stack)) {
            name = name.method_27694(style -> style.method_36139(this.method_7800(stack)));
        }
        return starIndex != null ? class_2561.method_43469((String)"item.starcaller.stardust.named", (Object[])new Object[]{name}).method_27692(class_124.field_1080) : name;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> list, class_1836 tooltipContext) {
        class_5250 editor;
        super.method_7851(stack, world, list, tooltipContext);
        Long remainingTicks = StardustItem.getRemainingTicks(stack, world);
        if (remainingTicks != null) {
            if (remainingTicks < 0L) {
                list.clear();
                return;
            }
            list.add(StardustItem.getCountdown(remainingTicks));
        }
        if ((editor = StardustItem.getEditor(stack)) != null) {
            list.add((class_2561)class_2561.method_43469((String)"item.starcaller.stardust.editor", (Object[])new Object[]{editor}).method_27692(class_124.field_1080));
        }
    }

    public boolean method_31567(class_1799 stack) {
        return Starcaller.TICKER.isItemBarVisible(stack);
    }

    public int method_31569(class_1799 stack) {
        return Starcaller.TICKER.getItemBarStep(stack);
    }

    public int method_31571(class_1799 stack) {
        if (this.method_7801(stack)) {
            return this.method_7800(stack);
        }
        return 0xFFFFFF;
    }

    private void dissipateEffect(class_1799 stack, class_1937 world, class_243 pos, int count) {
        if (world instanceof class_3218) {
            class_3218 sw = (class_3218)world;
            sw.method_43128(null, pos.field_1352, pos.field_1351, pos.field_1350, class_3417.field_26980, class_3419.field_15248, 3.0f, 2.0f);
            sw.method_43128(null, pos.field_1352, pos.field_1351, pos.field_1350, class_3417.field_43155, class_3419.field_15248, 0.8f, 2.0f);
            sw.method_14199((class_2394)new class_2390(ColorUtil.colorToComponents(this.method_31571(stack)), 0.6f), pos.field_1352, pos.field_1351, pos.field_1350, count, 0.5, 0.125, 0.5, 0.0);
        }
    }

    private void forceDissipate(class_1799 stack, class_1937 world, class_243 pos) {
        this.dissipateEffect(stack, world, pos, 40);
        Star star = StardustItem.getStar(stack, world);
        if (world instanceof StarcallerWorld) {
            StarcallerWorld scw = (StarcallerWorld)world;
            if (star != null) {
                scw.starcaller$freeStar(null, star);
            }
        }
    }

    private void tick(class_1799 stack, class_1937 world, class_243 pos) {
        Long remainingTicks = StardustItem.getRemainingTicks(stack, world);
        if (remainingTicks == null || remainingTicks <= 0L) {
            this.dissipateEffect(stack, world, pos, 20);
            stack.method_7934(stack.method_7947());
        }
    }

    public void method_54465(class_1799 stack, class_1937 world, class_1657 playerEntity) {
        super.method_54465(stack, world, playerEntity);
        Long remainingTicks = StardustItem.getRemainingTicks(stack, world);
        Star star = StardustItem.getStar(stack, world);
        if (world instanceof StarcallerWorld) {
            StarcallerWorld scw = (StarcallerWorld)world;
            if (star != null && remainingTicks != null && remainingTicks > 0L) {
                if (!world.field_9236 && !Objects.equals(remainingTicks, StardustItem.getWorldRemainingTicks(stack, world))) {
                    return;
                }
                scw.starcaller$colorStar(playerEntity, star, 0xFF000000 | this.method_7800(stack));
            }
        }
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 clickType, class_1657 player) {
        this.tick(stack, player.method_37908(), player.method_33571());
        return super.method_31565(stack, slot, clickType, player);
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        this.tick(stack, player.method_37908(), player.method_33571());
        return super.method_31566(stack, otherStack, slot, clickType, player, cursorStackReference);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        this.tick(stack, world, entity.method_33571());
        Long remainingTicks = StardustItem.getRemainingTicks(stack, world);
        if (world.field_9236 && selected && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (remainingTicks != null) {
                player.method_7353((class_2561)class_2561.method_43469((String)"item.starcaller.stardust.status", (Object[])new Object[]{StardustItem.getCountdown(remainingTicks)}).method_27692(class_124.field_1075), true);
            }
        }
    }

    public void blockInventoryTick(class_1799 stack, class_1937 world, class_2338 pos, int slot) {
        this.tick(stack, world, pos.method_46558());
    }

    public void entityInventoryTick(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.entityInventoryTick(stack, world, entity, slot, selected);
        this.forceDissipate(stack, world, entity.method_19538());
        entity.method_5650(class_1297.class_5529.field_26999);
    }
}

