/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.server;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import lynk.oneblock.utils.Server;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class GameObject {
    public static int breaks = 0;
    public static int breaksThisLevel = 0;
    public static int currentLevel = 1;
    public static int levelMultiplier = 2;
    public static int OneBlockPosX = 0;
    public static int OneBlockPosY = 100;
    public static int OneBlockPosZ = 0;
    public static int breaksPerLevel;
    public static int breaksNeededThisLevel;
    public static int percentageRareDrop;
    public static boolean rareDropInChest;
    public static int breaksPerChanceOnRareDrop;
    public static String[][] levels;
    public static String[] levelNames;
    public static String[][] rareDrops;
    public static String configFileLocation;
    public static String configFileName;

    public static void saveToJson() {
        Gson gson = new Gson();
        File directory = new File(configFileLocation);
        if (!directory.exists()) {
            boolean dirCreated = directory.mkdirs();
            if (dirCreated) {
                System.out.println("oneblock: Config directory created successfully");
            } else {
                System.out.println("oneblock: Failed to create config directory");
                return;
            }
        }
        gson = new Gson();
        GameObjectState state = new GameObjectState();
        String json = gson.toJson((Object)state);
        File file = new File(configFileLocation + configFileName);
        try {
            if (file.createNewFile()) {
                System.out.println("oneblock: File created: " + file.getName());
            } else {
                System.out.println("MOD_SAYS + File already exists.");
            }
            FileWriter writer = new FileWriter(file);
            writer.write(json);
            writer.close();
            System.out.println("Successfully wrote to the file.");
        }
        catch (IOException e) {
            System.out.println("oneblock: An error occurred.");
            e.printStackTrace();
        }
    }

    public static void loadFromJson() {
        String filePath = configFileLocation + configFileName;
        if (!Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0])) {
            System.err.println("File not found: " + filePath);
            return;
        }
        try (FileReader reader = new FileReader(filePath);){
            Gson gson = new Gson();
            JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            if (jsonObject.has("breaks")) {
                breaks = (Integer)gson.fromJson(jsonObject.get("breaks"), Integer.TYPE);
            }
            if (jsonObject.has("breaksThisLevel")) {
                breaksThisLevel = (Integer)gson.fromJson(jsonObject.get("breaksThisLevel"), Integer.TYPE);
            }
            if (jsonObject.has("currentLevel")) {
                currentLevel = (Integer)gson.fromJson(jsonObject.get("currentLevel"), Integer.TYPE);
            }
            if (jsonObject.has("levelMultiplier")) {
                levelMultiplier = (Integer)gson.fromJson(jsonObject.get("levelMultiplier"), Integer.TYPE);
            }
            if (jsonObject.has("OneBlockPosX")) {
                OneBlockPosX = (Integer)gson.fromJson(jsonObject.get("OneBlockPosX"), Integer.TYPE);
            }
            if (jsonObject.has("OneBlockPosY")) {
                OneBlockPosY = (Integer)gson.fromJson(jsonObject.get("OneBlockPosY"), Integer.TYPE);
            }
            if (jsonObject.has("OneBlockPosZ")) {
                OneBlockPosZ = (Integer)gson.fromJson(jsonObject.get("OneBlockPosZ"), Integer.TYPE);
            }
            if (jsonObject.has("breaksPerLevel")) {
                breaksPerLevel = (Integer)gson.fromJson(jsonObject.get("breaksPerLevel"), Integer.TYPE);
                breaksNeededThisLevel = (Integer)gson.fromJson(jsonObject.get("breaksPerLevel"), Integer.TYPE);
                Integer i = 1;
                while (i < currentLevel) {
                    breaksNeededThisLevel *= levelMultiplier;
                    Integer n = i;
                    i = i + 1;
                }
            }
            if (jsonObject.has("percentageRareDrop")) {
                percentageRareDrop = (Integer)gson.fromJson(jsonObject.get("percentageRareDrop"), Integer.TYPE);
            }
            if (jsonObject.has("rareDropInChest")) {
                rareDropInChest = (Boolean)gson.fromJson(jsonObject.get("rareDropInChest"), Boolean.TYPE);
            }
            if (jsonObject.has("breaksPerChanceOnRareDrop")) {
                breaksPerChanceOnRareDrop = (Integer)gson.fromJson(jsonObject.get("breaksPerChanceOnRareDrop"), Integer.TYPE);
            }
            if (jsonObject.has("levels")) {
                levels = (String[][])gson.fromJson(jsonObject.get("levels"), String[][].class);
            }
            if (jsonObject.has("rareDrops")) {
                rareDrops = (String[][])gson.fromJson(jsonObject.get("rareDrops"), String[][].class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class_2338 getOneBlockPos() {
        class_2338 oneBlockPos = new class_2338(OneBlockPosX, OneBlockPosY, OneBlockPosZ);
        return oneBlockPos;
    }

    public static void incrementOneBlockBroken() {
        ++breaks;
        ++breaksThisLevel;
    }

    public static void determineLevel(MinecraftServer server) {
        if (breaksThisLevel == breaksNeededThisLevel && currentLevel < levels.length) {
            breaksThisLevel = 0;
            breaksNeededThisLevel *= levelMultiplier;
            String message = "oneblock: OneBlock leveled up! Now level: " + ++currentLevel;
            server.method_3760().method_43514(class_2561.method_30163((String)message), false);
            if (levelNames[currentLevel - 1] != null) {
                message = "oneblock: Level theme: " + levelNames[currentLevel - 1];
                server.method_3760().method_43514(class_2561.method_30163((String)message), false);
            }
        }
    }

    public static class_1799 selectRare(class_1937 world) {
        Boolean itemFound = false;
        class_1799 stack = new class_1799((class_1935)class_1802.field_8831);
        MinecraftServer server = world.method_8503();
        Integer randomLevel = Server.randomInt(currentLevel);
        Integer maxRareLevel = rareDrops.length;
        Integer randomRare = null;
        if (randomLevel < maxRareLevel) {
            randomRare = Server.randomInt(rareDrops[randomLevel].length);
        } else {
            randomLevel = Server.randomInt(maxRareLevel);
            randomRare = Server.randomInt(rareDrops[maxRareLevel - 1].length);
        }
        for (class_1792 item : class_7923.field_41178) {
            if (!item.method_7848().getString().toUpperCase().equals(rareDrops[randomLevel][randomRare].toUpperCase())) continue;
            stack = new class_1799((class_1935)item);
            itemFound = true;
        }
        if (!itemFound.booleanValue()) {
            String message = "oneblock: Could not find the following item: \n " + rareDrops[randomLevel][randomRare].toString();
            server.method_3760().method_43514(class_2561.method_30163((String)message), false);
        }
        return stack;
    }

    public static void spawnChestWithRare(class_1937 world) {
        world.method_8652(GameObject.getOneBlockPos(), class_2246.field_10034.method_9564(), 3);
        class_2586 class_25862 = world.method_8321(GameObject.getOneBlockPos());
        if (class_25862 instanceof class_2595) {
            class_2595 chestBlockEntity = (class_2595)class_25862;
            chestBlockEntity.method_5447(0, GameObject.selectRare(world));
            world.method_8413(GameObject.getOneBlockPos(), class_2246.field_10034.method_9564(), class_2246.field_10034.method_9564(), 3);
        }
    }

    public static void spawnRareItem(class_1937 world) {
        world.method_8649((class_1297)new class_1542(world, (double)GameObject.getOneBlockPos().method_10263(), (double)(GameObject.getOneBlockPos().method_10264() + 1), (double)GameObject.getOneBlockPos().method_10260(), GameObject.selectRare(world)));
    }

    public static void respawnOneBlock(class_1937 world) {
        MinecraftServer server = world.method_8503();
        Integer randomLevel = Server.randomInt(currentLevel);
        Integer randomBlock = Server.randomInt(levels[randomLevel].length);
        Boolean blockFound = false;
        for (class_2248 block : class_7923.field_41175) {
            if (!block.method_9518().getString().toUpperCase().equals(levels[randomLevel][randomBlock].toString().toUpperCase())) continue;
            world.method_8501(GameObject.getOneBlockPos(), block.method_9564());
            blockFound = true;
        }
        if (!blockFound.booleanValue()) {
            world.method_8501(GameObject.getOneBlockPos(), class_2246.field_10219.method_9564());
            String message = "oneblock: Could not find the following block: \n " + levels[randomLevel][randomBlock].toString();
            server.method_3760().method_43514(class_2561.method_30163((String)message), false);
        }
    }

    public static int calculateRemainingBreaks() {
        return breaksNeededThisLevel - breaksThisLevel;
    }

    static {
        breaksNeededThisLevel = breaksPerLevel = 100;
        percentageRareDrop = 50;
        rareDropInChest = false;
        breaksPerChanceOnRareDrop = 50;
        levels = new String[][]{{"DIRT", "GRASS BLOCK", "PODZOL", "MYCELIUM"}, {"OAK LOG", "BIRCH LOG", "SPRUCE LOG", "JUNGLE LOG", "ACACIA LOG", "DARK OAK LOG"}, {"STONE", "COBBLESTONE", "ANDESITE", "GRANITE", "DIORITE", "MOSSY COBBLESTONE"}, {"FARMLAND", "CLAY", "SUGAR CANE", "PUMPKIN", "MELON"}, {"NETHER RACK", "GLOWSTONE", "QUARTZ ORE", "MAGMA BLOCK", "SOUL SOIL", "BASALT"}, {"OAK LEAVES", "BIRCH LEAVES", "JUNGLE LEAVES", "ACACIA LEAVES", "DARK OAK LEAVES", "CRIMSON STEM", "WARPED STEM"}, {"COAL ORE", "IRON ORE", "GOLD ORE", "LAPIS LAZULI ORE", "DIAMOND ORE", "EMERALD ORE", "REDSTONE ORE"}, {"SANDSTONE", "CHISELED SANDSTONE", "CUT SANDSTONE", "PRISMARINE", "SEA LANTERN", "TERRACOTTA", "GLASS"}, {"END STONE", "PURPUR BLOCK", "END STONE BRICKS", "CHORUS PLANT", "PURPUR PILLAR"}, {"BLACKSTONE", "CRIMSON NYLIUM", "WARPED NYLIUM", "GILDED BLACKSTONE", "NETHER BRICK", "SHROOMLIGHT"}, {"CORAL BLOCK", "CORAL", "CORAL FAN", "SPONGE", "WET SPONGE"}, {"ICE", "SNOW", "PACKED ICE", "BLUE ICE", "SNOW BLOCK"}, {"DEEPSLATE", "COBBLED DEEPSLATE", "POLISHED DEEPSLATE", "DEEPSLATE COAL ORE", "DEEPSLATE IRON ORE", "DEEPSLATE COPPER ORE"}, {"BRICKS", "STONE BRICKS", "CRACKED STONE BRICKS", "MOSSY STONE BRICKS", "CHISELED STONE BRICKS", "SMOOTH STONE"}, {"BAMBOO", "SUGAR CANE", "VINE", "LILY PAD", "DANDELION", "POPPY", "BLUE ORCHID"}, {"TUFF", "CALCITE", "AMETHYST BLOCK", "COPPER ORE", "RAW COPPER BLOCK", "RAW IRON BLOCK"}, {"GRASS", "FERN", "DEAD BUSH", "SEA GRASS", "AZALEA", "FLOWERING AZALEA"}, {"POLISHED GRANITE", "POLISHED DIORITE", "POLISHED ANDESITE", "POLISHED BASALT", "CHISELED QUARTZ BLOCK", "QUARTZ BRICKS"}, {"PRISMARINE BRICKS", "DARK PRISMARINE", "TUBE CORAL BLOCK", "BRAIN CORAL BLOCK", "BUBBLE CORAL BLOCK", "FIRE CORAL BLOCK"}, {"CRYING OBSIDIAN", "END GATEWAY", "PURPUR PILLAR", "END ROD", "OBSIDIAN", "RESPAWN ANCHOR"}, {"MOSS BLOCK", "GLOW BERRIES", "DRIP LEAF", "SPORADIC BLOSSOM", "CLAY BALL", "HANGING ROOTS", "MOSS CARPET"}, {"SCULK SENSOR", "SCULK GROWTH", "SCULK VEIN", "SCULK CATALYST", "SCULK SHRIEKER", "DEEPSLATE GOLD ORE", "DEEPSLATE REDSTONE ORE"}, {"STONE", "GRAVEL", "IRON ORE", "COAL ORE", "COPPER ORE", "GLOW LICHEN", "POWDERED SNOW CAULDRON"}, {"TUFF", "CALCITE", "DEEPSLATE DIAMOND ORE", "DEEPSLATE EMERALD ORE", "DEEPSLATE LAPIS LAZULI ORE", "DEEPSLATE REDSTONE ORE"}, {"DEEPSLATE COPPER ORE", "POINTED DRIPSTONE", "DRIPSTONE BLOCK", "AMETHYST BUDS", "AMETHYST CLUSTER", "BUDDING AMETHYST"}, {"MOSSY COBBLESTONE", "MOSSY STONE BRICKS", "MUD", "HONEYCOMB BLOCK", "NETHER WART BLOCK", "WARPED WART BLOCK"}, {"SOUL SAND", "BASALT", "WEEPING VINES", "TWISTING VINES", "CRIMSON FUNGUS", "WARPED FUNGUS"}, {"JUNGLE LOG", "VINE", "LILY PAD", "MELON BLOCK", "COCOA BEANS", "LARGE FERN", "BAMBOO"}, {"SPRUCE LOG", "SNOW BLOCK", "ICE", "PACKED ICE", "BLUE ICE", "FROSTED ICE"}, {"GLOWSTONE", "JACK O'LANTERN", "LANTERN", "TORCH", "SEA LANTERN", "END ROD", "SHROOMLIGHT"}};
        levelNames = new String[]{"Basic Natural Blocks", "Basic Wood Types", "Stone Variants", "Farming Soil and Plants", "Nether Basics", "Leaves and More Wood Variants", "Ores and Minerals", "Decorative Blocks", "End Blocks", "Advanced Nether Blocks", "Ocean and Coral", "Ice and Snow", "Deepslate Variants", "Building Blocks", "Exotic Wood and Plants", "Rare Earths and Stones", "A Touch of Green", "Varied Stone Types", "Underwater Blocks", "End Game Blocks", "Lush Caves", "Deep Dark Biome", "Mountain Peaks", "Underground Blocks", "Deepslate Ores and Cave Formations", "Lush Underground and Rare Decoratives", "Nether Expansion 2", "Jungle and Swamp", "Taiga and Snowy Biomes", "Overworld Nighttime"};
        rareDrops = new String[][]{{"STRING", "BONE", "ARROW", "ROTTEN FLESH", "FEATHER", "LEATHER", "EGG", "SOUL SAND", "SAND"}, {"WHEAT", "SEEDS", "APPLE", "CARROT", "POTATO", "SUGAR CANE", "PUMPKIN SEEDS", "MELON SEEDS"}, {"FLINT", "COAL", "IRON NUGGET", "GOLD NUGGET", "REDSTONE", "LAPIS LAZULI"}, {"NETHER QUARTZ", "GLOWSTONE DUST", "BLAZE ROD", "NETHER WART", "GHAST TEAR", "MAGMA CREAM"}, {"RAW FISH", "RAW SALMON", "PUFFERFISH", "TROPICAL FISH", "PRISMARINE CRYSTALS", "PRISMARINE SHARD"}, {"ENDER PEARL", "SLIME BALL", "SPIDER EYE", "GUNPOWDER", "PHANTOM MEMBRANE", "SHULKER SHELL"}, {"DIAMOND", "EMERALD", "GOLD ORE", "IRON ORE", "COPPER ORE"}, {"END CRYSTAL", "ENDER PEARL", "DRAGON'S BREATH", "ELYTRA", "SHULKER SHELL"}, {"BAMBOO", "COCOA BEANS", "CHORUS FRUIT", "PODZOL", "MYCELIUM", "BLUE ICE"}, {"HONEYCOMB", "NETHERITE SCRAP", "ANCIENT DEBRIS", "AMETHYST SHARD", "GLOW BERRIES"}, {"SPIDER EYE", "ENDER PEARL", "BONE", "STRING", "GUNPOWDER", "ZOMBIE FLESH", "KELP", "SEA GRASS", "SEA PICKLE"}, {"CARROT", "POTATO", "BEETROOT", "WHEAT", "MELON SLICE", "PUMPKIN"}, {"OAK SAPLING", "BIRCH SAPLING", "SPRUCE SAPLING", "JUNGLE SAPLING", "ACACIA SAPLING", "DARK OAK SAPLING"}, {"CACTUS", "DEAD BUSH", "RABBIT HIDE", "RABBIT FOOT", "PRISMARINE SHARD", "PRISMARINE CRYSTALS"}, {"SNOWBALL", "ICE", "PACKED ICE", "BLUE ICE", "POLAR BEAR FUR", "FROSTED ICE", "POWDER SNOW"}, {"EMERALD", "DIAMOND", "GOLD ORE", "IRON ORE", "COAL", "REDSTONE"}, {"ENCHANTED BOOK", "GOLDEN APPLE", "ENCHANTED GOLDEN APPLE", "EXPERIENCE BOTTLE"}, {"SEA LANTERN", "SPONGE", "WET SPONGE", "HEART OF THE SEA", "NAUTILUS SHELL", "TROPICAL FISH"}, {"NETHER WART", "BLAZE ROD", "WITHER SKELETON SKULL", "NETHER BRICK", "MAGMA CREAM", "GOLD SWORD"}, {"SHULKER SHELL", "ELYTRA", "DRAGON HEAD", "END STONE", "PURPUR BLOCK", "END ROD"}, {"LILY OF THE VALLEY", "SUNFLOWER", "LILAC", "ROSE BUSH", "PEONY", "BLUE ORCHID"}, {"GLOWSTONE DUST", "QUARTZ", "NETHERITE INGOT", "BLACKSTONE", "GILDED BLACKSTONE", "CRYING OBSIDIAN"}, {"JUNGLE TEMPLE LOOT", "BAMBOO", "COCOA BEANS", "PARROT FEATHER", "OCELOT FUR", "MELON SEEDS"}, {"SWEET BERRIES", "FOX FUR", "SPRUCE SAPLING", "RABBIT STEW", "WOLF FUR", "BEE NEST"}, {"EMERALD ORE", "SILVERFISH STONE", "GOAT HORN", "SNOW GOLEM HEAD", "MOUNTAIN MAP", "IRON PICKAXE"}, {"GOLDEN APPLE", "DIAMOND HORSE ARMOR", "GOLD INGOT", "IRON INGOT", "BONE MEAL", "SADDLE"}, {"PRISMARINE CRYSTALS", "PRISMARINE SHARD", "SPONGE", "SEA LANTERN", "WET SPONGE", "GOLD BLOCK"}, {"MOOSHROOM FUR", "MUSHROOM", "RED MUSHROOM BLOCK", "BROWN MUSHROOM BLOCK", "MUSHROOM STEW", "MYCELIUM"}, {"EMERALD", "BOOKSHELF", "CLOCK", "COMPASS", "MAP", "WRITTEN BOOK"}, {"GOLDEN APPLE", "ENAMELLED SKULL", "CURSED ARMOR", "TREASURE MAP", "HEART OF THE SEA", "CONDUIT"}};
        configFileLocation = "config/OneBlock/";
        configFileName = "OneBlock.json";
    }

    private static class GameObjectState {
        int breaks = breaks;
        int breaksThislevel = breaksThisLevel;
        int currentLevel = currentLevel;
        int levelMultiplier = levelMultiplier;
        int oneBlockPosX = OneBlockPosX;
        int oneBlockPosY = OneBlockPosY;
        int oneBlockPosZ = OneBlockPosZ;
        int breaksPerLevel = breaksPerLevel;
        int breaksNeededThisLevel;
        int percentageRareDrop = percentageRareDrop;
        boolean rareDropInChest = rareDropInChest;
        int breaksPerChanceOnRareDrop = breaksPerChanceOnRareDrop;
        String[][] levels = levels;
        String[] levelNames = levelNames;
        String[][] rareDrops = rareDrops;

        GameObjectState() {
        }
    }
}

