/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.config;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.pneumono.pneumonocore.config.AbstractConfiguration;
import net.pneumono.pneumonocore.config.Configs;
import net.pneumono.pneumonocore.config.ModConfigurations;

@Environment(value=EnvType.CLIENT)
public class ClientConfigCommandRegistry {
    public static void registerClientConfigCommand() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"clientconfig").then(ClientCommandManager.literal((String)"get").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"modid", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new ModIDSuggestionProvider()).then(ClientCommandManager.argument((String)"config", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new ConfigSuggestionProvider()).executes(context -> {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)ClientConfigCommandRegistry.getConfigValueString(StringArgumentType.getString((CommandContext)context, (String)"modid"), StringArgumentType.getString((CommandContext)context, (String)"config"))).method_27692(class_124.field_1075));
            return 1;
        }))).executes(context -> {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Configs:"));
            List<String> configs = ClientConfigCommandRegistry.getAllConfigValueStrings(StringArgumentType.getString((CommandContext)context, (String)"modid"));
            if (configs.isEmpty()) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"   None!"));
            } else {
                for (String config : configs) {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("   " + config)));
                }
            }
            return 1;
        })))));
    }

    public static List<String> getAllConfigValueStrings(String modID) {
        ArrayList<String> returnConfigs = new ArrayList<String>();
        for (ModConfigurations modConfigs : Configs.CONFIGS) {
            if (!Objects.equals(modConfigs.modID, modID)) continue;
            for (AbstractConfiguration<?> config : modConfigs.configurations) {
                returnConfigs.add(config.getModID() + ":" + config.getName() + " is set to " + config.getReloadableLoadedValue(false).toString());
            }
        }
        return returnConfigs;
    }

    public static String getConfigValueString(String modID, String name) {
        for (ModConfigurations modConfigs : Configs.CONFIGS) {
            if (!Objects.equals(modConfigs.modID, modID)) continue;
            for (AbstractConfiguration<?> config : modConfigs.configurations) {
                if (!Objects.equals(config.getName(), name)) continue;
                return config.getModID() + ":" + config.getName() + " is set to " + config.getReloadableLoadedValue(false).toString();
            }
        }
        return modID + ":" + name + " does not exist!";
    }

    @Environment(value=EnvType.CLIENT)
    public static class ModIDSuggestionProvider
    implements SuggestionProvider<FabricClientCommandSource> {
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder builder) {
            for (ModConfigurations modConfigs : Configs.CONFIGS) {
                if (!modConfigs.modID.toLowerCase().startsWith(builder.getRemainingLowerCase())) continue;
                builder.suggest(modConfigs.modID);
            }
            return builder.buildFuture();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ConfigSuggestionProvider
    implements SuggestionProvider<FabricClientCommandSource> {
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder builder) {
            for (ModConfigurations modConfigs : Configs.CONFIGS) {
                if (!Objects.equals(modConfigs.modID, StringArgumentType.getString(context, (String)"modid"))) continue;
                for (AbstractConfiguration<?> config : modConfigs.configurations) {
                    if (!config.getName().toLowerCase().startsWith(builder.getRemainingLowerCase())) continue;
                    builder.suggest(config.getName());
                }
            }
            return builder.buildFuture();
        }
    }
}

