/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.config;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_353;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4667;
import net.minecraft.class_5244;
import net.minecraft.class_7172;
import net.pneumono.pneumonocore.config.AbstractConfiguration;
import net.pneumono.pneumonocore.config.BooleanConfiguration;
import net.pneumono.pneumonocore.config.Configs;
import net.pneumono.pneumonocore.config.DoubleConfiguration;
import net.pneumono.pneumonocore.config.EnumConfiguration;
import net.pneumono.pneumonocore.config.IntegerConfiguration;
import net.pneumono.pneumonocore.config.ModConfigurations;

@Environment(value=EnvType.CLIENT)
public class ConfigOptionsScreen
extends class_4667 {
    private final String modID;
    private final class_437 previous;
    private class_353 list;
    private final List<StoredConfigValue<?>> storedValues = new ArrayList();

    public ConfigOptionsScreen(class_437 previous, String modID) {
        super(previous, class_310.method_1551().field_1690, (class_2561)class_2561.method_43471((String)(modID + ".configs_screen.title")));
        this.previous = previous;
        this.modID = modID;
    }

    protected void method_25426() {
        this.list = new class_353(this.field_22787, this.field_22789, this.field_22790, 32, this.field_22790 - 32, 25);
        this.list.method_20408(this.asOptions());
        this.method_25429((class_364)this.list);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"pneumonocore.configs_screen.reset"), button -> {
            for (ModConfigurations modConfigs : Configs.CONFIGS) {
                if (!Objects.equals(modConfigs.modID, this.modID)) continue;
                for (AbstractConfiguration<?> config : modConfigs.configurations) {
                    this.storedValues.add(new StoredConfigValue(config.modID, config.name, config.getDefaultValue()));
                }
            }
        }).method_46434(this.field_22789 / 2 - 155, this.field_22790 - 29, 150, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> {
            this.save();
            Objects.requireNonNull(this.field_22787).method_1507(this.previous);
        }).method_46434(this.field_22789 / 2 + 5, this.field_22790 - 29, 150, 20).method_46431());
    }

    public void method_25394(class_332 DrawContext, int mouseX, int mouseY, float delta) {
        super.method_25394(DrawContext, mouseX, mouseY, delta);
        this.list.method_25394(DrawContext, mouseX, mouseY, delta);
        DrawContext.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 5, 0xFFFFFF);
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25434(context);
    }

    public void method_25432() {
        this.save();
    }

    private void save() {
        for (ModConfigurations modConfigs : Configs.CONFIGS) {
            if (!Objects.equals(modConfigs.modID, this.modID)) continue;
            block1: for (StoredConfigValue<?> storedValue : this.storedValues) {
                for (AbstractConfiguration<?> config : modConfigs.configurations) {
                    if (!Objects.equals(config.name, storedValue.name)) continue;
                    config.setLoadedValue(storedValue.newValue);
                    continue block1;
                }
            }
            modConfigs.writeConfigs(modConfigs.configurations, false);
        }
    }

    private class_7172<?>[] asOptions() {
        ArrayList options = new ArrayList();
        for (ModConfigurations modConfigs : Configs.CONFIGS) {
            if (!Objects.equals(modConfigs.modID, this.modID)) continue;
            for (AbstractConfiguration<?> config : modConfigs.configurations) {
                class_7172<?> option = this.asOption(config);
                if (option == null) continue;
                options.add(option);
            }
        }
        return (class_7172[])options.toArray(class_7172[]::new);
    }

    private class_7172<?> asOption(AbstractConfiguration<?> config) {
        String translationKey = this.getConfigKey(config.modID, config.name);
        if (config instanceof BooleanConfiguration) {
            BooleanConfiguration booleanConfig = (BooleanConfiguration)config;
            return new class_7172(translationKey, class_7172.method_42717((class_2561)class_2561.method_43471((String)(translationKey + ".tooltip"))), (text, value) -> class_2561.method_43471((String)(value != false ? "pneumonocore.configs_screen.boolean_enabled" : "pneumonocore.configs_screen.boolean_disabled")), (class_7172.class_7178)class_7172.field_38278, (Object)((Boolean)booleanConfig.getLoadedValue()), newValue -> this.storedValues.add(new StoredConfigValue<Boolean>(config.modID, config.name, (Boolean)newValue)));
        }
        if (config instanceof EnumConfiguration) {
            EnumConfiguration enumConfig = (EnumConfiguration)config;
            return new class_7172(translationKey, class_7172.method_42717((class_2561)class_2561.method_43471((String)(translationKey + ".tooltip"))), (text, value) -> class_2561.method_43471((String)(translationKey + "." + value.name().toLowerCase())), (class_7172.class_7178)new class_7172.class_7173(Arrays.asList((Enum[])enumConfig.getEnumClass().getEnumConstants()), Codec.STRING.xmap(string -> Arrays.stream((Enum[])enumConfig.getEnumClass().getEnumConstants()).filter(e -> e.name().toLowerCase().equals(string)).findAny().orElse(null), newValue -> newValue.name().toLowerCase())), (Object)((Enum)enumConfig.getLoadedValue()), newValue -> this.storedValues.add(new StoredConfigValue<Enum>(config.modID, config.name, (Enum)newValue)));
        }
        if (config instanceof IntegerConfiguration) {
            IntegerConfiguration intConfig = (IntegerConfiguration)config;
            return new class_7172(translationKey, class_7172.method_42717((class_2561)class_2561.method_43471((String)(translationKey + ".tooltip"))), (text, value) -> class_2561.method_43471((String)translationKey).method_10852(class_2561.method_30163((String)(": " + value.toString()))), (class_7172.class_7178)new class_7172.class_7174(intConfig.getMinValue(), intConfig.getMaxValue()), (Object)((Integer)intConfig.getLoadedValue()), newValue -> this.storedValues.add(new StoredConfigValue<Integer>(config.modID, config.name, (Integer)newValue)));
        }
        if (config instanceof DoubleConfiguration) {
            DoubleConfiguration doubleConfig = (DoubleConfiguration)config;
            return new class_7172(translationKey, class_7172.method_42717((class_2561)class_2561.method_43471((String)(translationKey + ".tooltip"))), (text, value) -> class_2561.method_43471((String)translationKey).method_10852(class_2561.method_30163((String)(": " + value.toString()))), (class_7172.class_7178)class_7172.class_7177.field_37875, (Object)((Double)doubleConfig.getLoadedValue()), newValue -> this.storedValues.add(new StoredConfigValue<Double>(config.modID, config.name, (Double)newValue)));
        }
        return null;
    }

    private String getConfigKey(String modID, String name) {
        return modID + ".configs." + name;
    }

    @Environment(value=EnvType.CLIENT)
    private record StoredConfigValue<T>(String modID, String name, T newValue) {
    }
}

