/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.umbrellas.content;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_6880;
import net.pneumono.umbrellas.content.UmbrellaItem;
import net.pneumono.umbrellas.patterns.PatternRegistry;
import net.pneumono.umbrellas.patterns.UmbrellaPattern;
import org.jetbrains.annotations.Nullable;

public class PatternableUmbrellaItem
extends UmbrellaItem {
    private final class_1767 baseColor;

    public PatternableUmbrellaItem(class_1792.class_1793 settings, class_1767 baseColor) {
        super(settings);
        this.baseColor = baseColor;
    }

    public class_1767 getBaseColor() {
        return this.baseColor;
    }

    public static List<Pair<class_6880<UmbrellaPattern>, class_1767>> getPatternsFromNbt(class_1799 stack) {
        class_1767 class_17672;
        class_2487 nbt = stack.method_7969();
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof PatternableUmbrellaItem) {
            PatternableUmbrellaItem umbrella = (PatternableUmbrellaItem)class_17922;
            class_17672 = umbrella.getBaseColor();
        } else {
            class_17672 = class_1767.field_7952;
        }
        class_1767 baseColor = class_17672;
        class_2499 patternListNbt = null;
        if (nbt != null && nbt.method_10573("Patterns", 9)) {
            patternListNbt = nbt.method_10554("Patterns", 10).method_10612();
        }
        ArrayList list = Lists.newArrayList();
        list.add(Pair.of((Object)PatternRegistry.UMBRELLA_PATTERN.method_40290(PatternRegistry.keyOf("base")), (Object)baseColor));
        if (patternListNbt != null) {
            for (int i = 0; i < patternListNbt.size(); ++i) {
                class_2487 nbtCompound = patternListNbt.method_10602(i);
                class_6880<UmbrellaPattern> registryEntry = UmbrellaPattern.byId(nbtCompound.method_10558("Pattern"));
                if (registryEntry == null) continue;
                list.add(Pair.of(registryEntry, (Object)class_1767.method_7791((int)nbtCompound.method_10550("Color"))));
            }
        }
        return list;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        class_2487 nbtCompound = stack.method_7969();
        if (nbtCompound == null || !nbtCompound.method_10545("Patterns")) {
            return;
        }
        class_2499 nbtList = nbtCompound.method_10554("Patterns", 10);
        for (int i = 0; i < nbtList.size() && i < 6; ++i) {
            class_2487 nbtCompound2 = nbtList.method_10602(i);
            class_1767 dyeColor = class_1767.method_7791((int)nbtCompound2.method_10550("Color"));
            class_6880<UmbrellaPattern> registryEntry = UmbrellaPattern.byId(nbtCompound2.method_10558("Pattern"));
            if (registryEntry == null) continue;
            registryEntry.method_40230().map(key -> key.method_29177().method_43903()).ifPresent(translationKey -> {
                if (((UmbrellaPattern)registryEntry.comp_349()).colored()) {
                    tooltip.add((class_2561)class_2561.method_43471((String)("tooltip.umbrellas.colors." + dyeColor.method_7792())).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)("tooltip." + translationKey))).method_27692(class_124.field_1080));
                } else {
                    tooltip.add((class_2561)class_2561.method_43471((String)("tooltip." + translationKey)).method_27692(class_124.field_1080));
                }
            });
        }
    }
}

