/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.umbrellas.mixin;

import com.google.common.collect.ImmutableList;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1726;
import net.minecraft.class_1735;
import net.minecraft.class_1745;
import net.minecraft.class_1746;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_6880;
import net.pneumono.umbrellas.content.PatternableUmbrellaItem;
import net.pneumono.umbrellas.patterns.LoomScreenHandlerAccess;
import net.pneumono.umbrellas.patterns.PatternRegistry;
import net.pneumono.umbrellas.patterns.PrideUmbrellaPatternItem;
import net.pneumono.umbrellas.patterns.UmbrellaPattern;
import net.pneumono.umbrellas.patterns.UmbrellaPatternItem;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1726.class})
public abstract class LoomHandlerMixin
extends class_1703
implements LoomScreenHandlerAccess {
    @Shadow
    @Final
    private class_3914 field_17316;
    @Shadow
    @Final
    private class_1263 field_7850;
    @Shadow
    @Final
    private class_1263 field_17323;
    @Shadow
    @Final
    @Mutable
    class_1735 field_17319;
    @Shadow
    @Final
    class_1735 field_17320;
    @Shadow
    long field_20383;
    @Shadow
    @Final
    @Mutable
    private class_1735 field_17321;
    @Shadow
    @Final
    private class_1735 field_17322;
    @Shadow
    @Final
    class_3915 field_17317;
    private List<class_6880<UmbrellaPattern>> umbrellaPatterns = List.of();
    private boolean usingUmbrella = false;

    protected LoomHandlerMixin(@Nullable class_3917<?> type, int syncId) {
        super(type, syncId);
    }

    @ModifyArg(method={"<init>(ILnet/minecraft/entity/player/PlayerInventory;Lnet/minecraft/screen/ScreenHandlerContext;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/screen/LoomScreenHandler;addSlot(Lnet/minecraft/screen/slot/Slot;)Lnet/minecraft/screen/slot/Slot;", ordinal=0), index=0)
    private class_1735 bannerAndUmbrellaSlot(final class_1735 slot) {
        return new class_1735(this.field_7850, 0, 13, 26){

            public boolean method_7680(class_1799 stack) {
                return slot.method_7680(stack) || stack.method_7909() instanceof PatternableUmbrellaItem;
            }
        };
    }

    @ModifyArg(method={"<init>(ILnet/minecraft/entity/player/PlayerInventory;Lnet/minecraft/screen/ScreenHandlerContext;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/screen/LoomScreenHandler;addSlot(Lnet/minecraft/screen/slot/Slot;)Lnet/minecraft/screen/slot/Slot;", ordinal=2), index=0)
    private class_1735 bothPatternsSlot(final class_1735 slot) {
        return new class_1735(this.field_7850, 2, 23, 45){

            public boolean method_7680(class_1799 stack) {
                return slot.method_7680(stack) || stack.method_7909() instanceof UmbrellaPatternItem;
            }
        };
    }

    @ModifyArg(method={"<init>(ILnet/minecraft/entity/player/PlayerInventory;Lnet/minecraft/screen/ScreenHandlerContext;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/screen/LoomScreenHandler;addSlot(Lnet/minecraft/screen/slot/Slot;)Lnet/minecraft/screen/slot/Slot;", ordinal=3), index=0)
    private class_1735 bothOutputSlot(final class_1735 slot) {
        return new class_1735(this.field_17323, 0, 143, 58){

            public boolean method_7680(class_1799 stack) {
                return slot.method_7680(stack);
            }

            public void method_7667(class_1657 player, class_1799 stack) {
                boolean shouldTakeDye;
                LoomHandlerMixin.this.field_17319.method_7671(1);
                boolean bl = shouldTakeDye = !(LoomHandlerMixin.this.field_17321.method_7677().method_7909() instanceof PrideUmbrellaPatternItem);
                if (shouldTakeDye) {
                    LoomHandlerMixin.this.field_17320.method_7671(1);
                }
                if (!LoomHandlerMixin.this.field_17319.method_7681() || !LoomHandlerMixin.this.field_17320.method_7681() && shouldTakeDye) {
                    LoomHandlerMixin.this.field_17317.method_17404(-1);
                }
                LoomHandlerMixin.this.field_17316.method_17393((world, pos) -> {
                    long l = world.method_8510();
                    if (LoomHandlerMixin.this.field_20383 != l) {
                        world.method_8396(null, pos, class_3417.field_15096, class_3419.field_15245, 1.0f, 1.0f);
                        LoomHandlerMixin.this.field_20383 = l;
                    }
                });
                super.method_7667(player, stack);
            }
        };
    }

    @Inject(method={"onButtonClick"}, at={@At(value="HEAD")}, cancellable=true)
    public void onButtonClickUmbrella(class_1657 player, int id, CallbackInfoReturnable<Boolean> infoReturnable) {
        if (this.usingUmbrella && id >= 0 && id < this.umbrellaPatterns.size()) {
            this.field_17317.method_17404(id);
            this.updateUmbrellaOutputSlot(this.umbrellaPatterns.get(id));
            infoReturnable.setReturnValue((Object)true);
        }
    }

    private List<class_6880<UmbrellaPattern>> getUmbrellaPatternsFor(class_1799 stack) {
        if (stack.method_7960()) {
            return (List)PatternRegistry.UMBRELLA_PATTERN.method_40266(PatternRegistry.NO_ITEM_REQUIRED).map(ImmutableList::copyOf).orElse(ImmutableList.of());
        }
        class_1792 item = stack.method_7909();
        if (item instanceof UmbrellaPatternItem) {
            UmbrellaPatternItem umbrellaPatternItem = (UmbrellaPatternItem)item;
            return (List)PatternRegistry.UMBRELLA_PATTERN.method_40266(umbrellaPatternItem.getPatternItemTag()).map(ImmutableList::copyOf).orElse(ImmutableList.of());
        }
        return List.of();
    }

    private boolean isUmbrellaPatternIndexValid(int index) {
        return index >= 0 && index < this.umbrellaPatterns.size();
    }

    @Inject(method={"onContentChanged"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isEmpty()Z")}, cancellable=true)
    private void onUmbrellaContentChanged(CallbackInfo callbackInfo, @Local(ordinal=0) class_1799 umbrellaStack, @Local(ordinal=1) class_1799 dyeStack, @Local(ordinal=2) class_1799 patternStack) {
        if (umbrellaStack.method_7909() instanceof PatternableUmbrellaItem) {
            class_6880<UmbrellaPattern> registryEntry;
            if (dyeStack.method_7960() && !(patternStack.method_7909() instanceof PrideUmbrellaPatternItem)) {
                this.field_17322.method_7673(class_1799.field_8037);
                this.umbrellaPatterns = List.of();
                this.field_17317.method_17404(-1);
                callbackInfo.cancel();
            }
            this.usingUmbrella = true;
            int index = this.field_17317.method_17407();
            boolean indexValid = this.isUmbrellaPatternIndexValid(index);
            List<class_6880<UmbrellaPattern>> list = this.umbrellaPatterns;
            this.umbrellaPatterns = this.getUmbrellaPatternsFor(patternStack);
            if (this.umbrellaPatterns.size() == 1) {
                this.field_17317.method_17404(0);
                registryEntry = this.umbrellaPatterns.get(0);
            } else if (!indexValid) {
                this.field_17317.method_17404(-1);
                registryEntry = null;
            } else {
                class_6880<UmbrellaPattern> registryEntry2 = list.get(index);
                int index2 = this.umbrellaPatterns.indexOf(registryEntry2);
                if (index2 != -1) {
                    registryEntry = registryEntry2;
                    this.field_17317.method_17404(index2);
                } else {
                    registryEntry = null;
                    this.field_17317.method_17404(-1);
                }
            }
            if (registryEntry != null) {
                boolean tooManyPatterns;
                class_2487 nbtCompound = umbrellaStack.method_7969();
                boolean bl = tooManyPatterns = nbtCompound != null && nbtCompound.method_10573("Patterns", 9) && !umbrellaStack.method_7960() && nbtCompound.method_10554("Patterns", 10).size() >= 6;
                if (tooManyPatterns) {
                    this.field_17317.method_17404(-1);
                    this.field_17322.method_7673(class_1799.field_8037);
                } else {
                    this.updateUmbrellaOutputSlot(registryEntry);
                }
            } else {
                this.field_17322.method_7673(class_1799.field_8037);
            }
            this.method_7623();
            callbackInfo.cancel();
        } else {
            this.usingUmbrella = false;
        }
    }

    @ModifyConstant(method={"quickMove"}, constant={@Constant(classValue=class_1746.class)})
    private boolean umbrellaItemCheck(Object reference, Class<?> bannerClass) {
        return reference instanceof class_1746 || reference instanceof PatternableUmbrellaItem;
    }

    @ModifyConstant(method={"quickMove"}, constant={@Constant(classValue=class_1745.class)})
    private boolean umbrellaPatternCheck(Object reference, Class<?> bannerPatternClass) {
        return reference instanceof class_1745 || reference instanceof UmbrellaPatternItem;
    }

    private void updateUmbrellaOutputSlot(class_6880<UmbrellaPattern> pattern) {
        class_1799 umbrellaStack = this.field_17319.method_7677();
        class_1799 dyeStack = this.field_17320.method_7677();
        class_1799 newUmbrellaStack = class_1799.field_8037;
        if (!(umbrellaStack.method_7960() || dyeStack.method_7960() && ((UmbrellaPattern)pattern.comp_349()).colored())) {
            class_2499 nbtList;
            class_1767 class_17672;
            newUmbrellaStack = umbrellaStack.method_7972();
            class_1792 class_17922 = dyeStack.method_7909();
            if (class_17922 instanceof class_1769) {
                class_1769 item = (class_1769)class_17922;
                class_17672 = item.method_7802();
            } else {
                class_17672 = class_1767.field_7952;
            }
            class_1767 dyeColor = class_17672;
            class_2487 nbtCompound = newUmbrellaStack.method_7969();
            if (nbtCompound != null && nbtCompound.method_10573("Patterns", 9)) {
                nbtList = nbtCompound.method_10554("Patterns", 10);
            } else {
                nbtList = new class_2499();
                if (nbtCompound == null) {
                    nbtCompound = new class_2487();
                }
                nbtCompound.method_10566("Patterns", (class_2520)nbtList);
            }
            class_2487 newPattern = new class_2487();
            newPattern.method_10582("Pattern", ((UmbrellaPattern)pattern.comp_349()).id());
            newPattern.method_10569("Color", dyeColor.method_7789());
            nbtList.add((Object)newPattern);
            newUmbrellaStack.method_7969().method_10566("Patterns", (class_2520)nbtList);
        }
        if (!class_1799.method_7973((class_1799)newUmbrellaStack, (class_1799)this.field_17322.method_7677())) {
            this.field_17322.method_7673(newUmbrellaStack);
        }
    }

    @Override
    public List<class_6880<UmbrellaPattern>> getUmbrellaPatterns() {
        return this.umbrellaPatterns;
    }
}

