/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.config;

import com.google.gson.JsonElement;
import java.util.Objects;
import net.minecraft.class_2960;
import net.pneumono.pneumonocore.config.ConfigEnv;
import net.pneumono.pneumonocore.config.Configs;
import net.pneumono.pneumonocore.config.ModConfigurations;

public abstract class AbstractConfiguration<T> {
    protected String modID;
    protected final String name;
    protected final ConfigEnv environment;
    protected boolean registered = false;
    private final T defaultValue;
    private T loadedValue;
    private T importedValue;

    public AbstractConfiguration(String modID, String name, ConfigEnv environment, T defaultValue) {
        this.modID = modID;
        this.name = name;
        this.environment = environment;
        this.defaultValue = defaultValue;
        this.loadedValue = defaultValue;
    }

    protected AbstractConfiguration(String modID, String name, ConfigEnv environment, T defaultValue, T loadedValue) {
        this.modID = modID;
        this.name = name;
        this.environment = environment;
        this.defaultValue = defaultValue;
        this.loadedValue = loadedValue;
    }

    protected String valueToJson(boolean useDefaultValues) {
        return useDefaultValues || this.loadedValue == null ? this.defaultValue.toString() : this.loadedValue.toString();
    }

    protected abstract AbstractConfiguration<T> fromElement(JsonElement var1);

    public abstract T valueFromElement(JsonElement var1);

    public boolean isClientSide() {
        return this.environment == ConfigEnv.CLIENT;
    }

    public String getModID() {
        return this.modID;
    }

    public String getName() {
        return this.name;
    }

    public class_2960 getID() {
        return new class_2960(this.modID, this.name);
    }

    public String getTranslationKey() {
        return "configs." + this.modID + "." + this.name;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    protected T getLoadedValue() {
        return this.loadedValue;
    }

    public T getValue() {
        return this.getValue(false);
    }

    private T getValue(boolean looped) {
        AbstractConfiguration<?> thisConfig = null;
        ModConfigurations modConfigs = Configs.CONFIGS.get(this.modID);
        if (modConfigs != null) {
            for (AbstractConfiguration<?> config : modConfigs.configurations) {
                if (!Objects.equals(config.name, this.name)) continue;
                thisConfig = config;
                break;
            }
        }
        return thisConfig != null ? (thisConfig.isClientSide() ? (T)thisConfig.getReloadableLoadedValue(looped) : (thisConfig.importedValue != null ? (T)thisConfig.importedValue : (T)thisConfig.getReloadableLoadedValue(looped))) : null;
    }

    protected T getReloadableLoadedValue(boolean looped) {
        return this.loadedValue != null || looped ? this.loadedValue : this.getReloadedValue();
    }

    private T getReloadedValue() {
        Configs.reload(this.modID);
        return this.getValue(true);
    }

    protected void setLoadedValue(Object value) {
        if (value != null) {
            this.loadedValue = value;
        }
    }

    protected void setImportedValue(AbstractConfiguration<?> config) {
        this.importedValue = config.loadedValue;
    }

    public abstract String getClassID();
}

