/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.minecraft.class_161;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_189;
import net.minecraft.class_1935;
import net.minecraft.class_2035;
import net.minecraft.class_2062;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_2105;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_6862;
import net.pneumono.pneumonocore.PneumonoCore;
import net.pneumono.pneumonocore.config.AbstractConfiguration;
import net.pneumono.pneumonocore.config.Configs;
import net.pneumono.pneumonocore.datagen.AbstractConfigCondition;
import net.pneumono.pneumonocore.datagen.AndConfigCondition;
import net.pneumono.pneumonocore.datagen.ConfigCondition;
import net.pneumono.pneumonocore.datagen.NotConfigCondition;
import net.pneumono.pneumonocore.datagen.OrConfigCondition;
import net.pneumono.pneumonocore.datagen.enums.ConditionType;
import net.pneumono.pneumonocore.datagen.enums.Operator;

public class PneumonoDatagenHelper {
    public static ConditionJsonProvider configValues(final AbstractConfigCondition ... configs) {
        return new ConditionJsonProvider(){

            public class_2960 getConditionId() {
                return new class_2960("pneumonocore", "config_values");
            }

            public void writeParameters(JsonObject object) {
                JsonArray array = new JsonArray();
                for (AbstractConfigCondition condition : configs) {
                    array.add((JsonElement)condition.toJson());
                }
                object.add("conditions", (JsonElement)array);
            }
        };
    }

    public static void registerResourceConditions() {
        ResourceConditions.register((class_2960)new class_2960("pneumonocore", "config_values"), object -> {
            List jsonConditions = class_3518.method_15261((JsonObject)object, (String)"conditions").asList();
            ArrayList<AbstractConfigCondition> conditions = new ArrayList<AbstractConfigCondition>();
            for (JsonElement jsonCondition : jsonConditions) {
                conditions.add(PneumonoDatagenHelper.parseConditionJson(jsonCondition.getAsJsonObject()));
            }
            Supplier<Boolean> booleanSupplier = () -> PneumonoDatagenHelper.conditionsFulfilled(conditions.toArray(new AbstractConfigCondition[0]));
            return booleanSupplier.get();
        });
    }

    public static boolean conditionsFulfilled(AbstractConfigCondition ... conditions) {
        boolean fulfilled = true;
        for (AbstractConfigCondition condition : conditions) {
            if (condition.conditionFulfilled()) continue;
            fulfilled = false;
            break;
        }
        return fulfilled;
    }

    private static AbstractConfigCondition parseConditionJson(JsonObject object) {
        ConditionType type = ConditionType.fromString(class_3518.method_15265((JsonObject)object, (String)"type"));
        switch (type) {
            case AND: {
                List jsonConditions = class_3518.method_15261((JsonObject)object, (String)"conditions").asList();
                ArrayList<AbstractConfigCondition> conditions = new ArrayList<AbstractConfigCondition>();
                for (JsonElement jsonCondition : jsonConditions) {
                    conditions.add(PneumonoDatagenHelper.parseConditionJson(jsonCondition.getAsJsonObject()));
                }
                return new AndConfigCondition(conditions.toArray(new AbstractConfigCondition[0]));
            }
            case OR: {
                List jsonConditions = class_3518.method_15261((JsonObject)object, (String)"conditions").asList();
                ArrayList<AbstractConfigCondition> conditions = new ArrayList<AbstractConfigCondition>();
                for (JsonElement jsonCondition : jsonConditions) {
                    conditions.add(PneumonoDatagenHelper.parseConditionJson(jsonCondition.getAsJsonObject()));
                }
                return new OrConfigCondition(conditions.toArray(new AbstractConfigCondition[0]));
            }
            case NOT: {
                JsonElement jsonCondition = class_3518.method_52226((JsonObject)object, (String)"condition");
                return new NotConfigCondition(PneumonoDatagenHelper.parseConditionJson(jsonCondition.getAsJsonObject()));
            }
        }
        class_2960 configurationID = new class_2960(class_3518.method_15265((JsonObject)object, (String)"configuration"));
        AbstractConfiguration<?> configuration = Configs.getConfig(configurationID.method_12836(), configurationID.method_12832());
        if (configuration != null) {
            Operator operator = Operator.fromString(class_3518.method_15265((JsonObject)object, (String)"operator"));
            return new ConfigCondition(configuration.getID(), operator, configuration.valueFromElement(class_3518.method_52226((JsonObject)object, (String)"value")));
        }
        PneumonoCore.LOGGER.warn("Invalid resource condition JSON!");
        return null;
    }

    public static class_2073 getTagItemPredicate(class_6862<class_1792> tagKey) {
        return new class_2073(tagKey, null, class_2096.class_2100.field_9708, class_2096.class_2100.field_9708, class_2035.field_20687, class_2035.field_20687, null, class_2105.field_9716);
    }

    public static class_2073 getEnchantmentItemPredicate(class_2035 enchantment) {
        return new class_2073(null, null, class_2096.class_2100.field_9708, class_2096.class_2100.field_9708, new class_2035[]{enchantment}, class_2035.field_20687, null, class_2105.field_9716);
    }

    public static class_161 getDummyAdvancement(class_2960 advancementID) {
        return class_161.class_162.method_707().method_697((class_1935)class_1802.field_8077, (class_2561)class_2561.method_43470((String)"Uh oh!"), (class_2561)class_2561.method_43470((String)"If you're reading this, something has gone very, very wrong"), null, class_189.field_1250, false, false, false).method_709("impossible", (class_184)new class_2062.class_2063()).method_695(advancementID);
    }
}

