/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.pneumono.pneumonocore.PneumonoCore;
import net.pneumono.pneumonocore.config.AbstractConfiguration;
import net.pneumono.pneumonocore.config.ModConfigurations;
import net.pneumono.pneumonocore.config.PackagedConfigs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configs {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"PneumonoCoreConfig");
    protected static List<ModConfigurations> CONFIGS = new ArrayList<ModConfigurations>();

    public static <T extends AbstractConfiguration<?>> T register(T configuration) {
        if (!Configs.isValid(configuration)) {
            LOGGER.error("Configuration " + configuration.modID + ":" + configuration.name + " was not registered successfully!");
            return configuration;
        }
        boolean modConfigExists = false;
        for (ModConfigurations modConfigs : CONFIGS) {
            if (!Objects.equals(modConfigs.modID, configuration.getModID())) continue;
            boolean isDuplicate = false;
            for (AbstractConfiguration<?> checkedConfiguration : modConfigs.configurations) {
                if (!Objects.equals(checkedConfiguration.name, configuration.name)) continue;
                isDuplicate = true;
                break;
            }
            if (!isDuplicate) {
                modConfigs.configurations.add(configuration);
                modConfigExists = true;
                break;
            }
            LOGGER.error("Configuration " + configuration.modID + ":" + configuration.name + " is a duplicate, and so was not registered!");
            break;
        }
        if (!modConfigExists) {
            CONFIGS.add(new ModConfigurations(configuration.getModID(), configuration));
        }
        configuration.registered = true;
        return configuration;
    }

    public static void reload(String modID) {
        for (ModConfigurations modConfigs : CONFIGS) {
            if (!Objects.equals(modConfigs.modID, modID)) continue;
            modConfigs.reload();
            break;
        }
    }

    public static void sendS2CConfigSyncPacket(List<class_3222> players) {
        class_2540 buffer = PacketByteBufs.create();
        String json = new PackagedConfigs().toJsonString();
        buffer.method_10814(json);
        for (class_3222 player : players) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)PneumonoCore.CONFIG_SYNC_ID, (class_2540)buffer);
        }
    }

    protected static void sendS2CConfigSyncPacket(class_3222 ... players) {
        Configs.sendS2CConfigSyncPacket(List.of(players));
    }

    private static boolean isValid(AbstractConfiguration<?> configuration) {
        return configuration.getName() != null && !Objects.equals(configuration.getName(), "") && configuration.getModID() != null && !Objects.equals(configuration.getModID(), "");
    }

    public static boolean hasConfigs(String modID) {
        for (ModConfigurations modConfigs : CONFIGS) {
            if (!modConfigs.modID.equals(modID) || modConfigs.configurations.size() <= 0) continue;
            return true;
        }
        return false;
    }

    public static AbstractConfiguration<?> getConfig(String modID, String name) {
        for (ModConfigurations modConfigs : CONFIGS) {
            if (!modConfigs.modID.equals(modID)) continue;
            for (AbstractConfiguration<?> config : modConfigs.configurations) {
                if (!Objects.equals(config.name, name)) continue;
                return config;
            }
        }
        LOGGER.warn("Requested config " + modID + ":" + name + ", which does not exist!");
        return null;
    }
}

