/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.config;

import com.google.gson.JsonElement;
import net.pneumono.pneumonocore.config.AbstractConfiguration;
import net.pneumono.pneumonocore.config.ConfigEnv;

public class EnumConfiguration<T extends Enum<T>>
extends AbstractConfiguration<T> {
    private final Class<T> enumClass;

    public EnumConfiguration(String modID, String name, ConfigEnv environment, T defaultValue) {
        super(modID, name, environment, defaultValue);
        this.enumClass = ((Enum)defaultValue).getDeclaringClass();
    }

    private EnumConfiguration(String modID, String name, ConfigEnv environment, T defaultValue, T loadedValue) {
        super(modID, name, environment, defaultValue, loadedValue);
        this.enumClass = ((Enum)defaultValue).getDeclaringClass();
    }

    @Override
    public EnumConfiguration<T> fromElement(JsonElement element) {
        return new EnumConfiguration<Object>(this.modID, this.name, this.environment, (Enum)this.getDefaultValue(), this.valueFromElement(element));
    }

    @Override
    public T valueFromElement(JsonElement element) {
        return this.getEnumFromString(element.getAsString());
    }

    private T getEnumFromString(String string) {
        for (Enum type : (Enum[])this.enumClass.getEnumConstants()) {
            if (!type.name().equalsIgnoreCase(string)) continue;
            return (T)type;
        }
        return (T)((Enum)this.getDefaultValue());
    }

    public Class<T> getEnumClass() {
        return this.enumClass;
    }

    @Deprecated
    public EnumConfiguration(String modID, String name, ConfigEnv environment, T defaultValue, String tooltip) {
        super(modID, name, environment, defaultValue);
        this.enumClass = ((Enum)defaultValue).getDeclaringClass();
    }
}

