/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.pneumono.pneumonocore.config.AbstractConfiguration;
import net.pneumono.pneumonocore.config.Configs;
import net.pneumono.pneumonocore.config.ModConfigurations;

public class PackagedConfigs {
    private final Set<AbstractConfiguration<?>> configs;

    public PackagedConfigs() {
        Configs.LOGGER.info("Creating new config sync packet");
        ArrayList packagedConfigs = new ArrayList();
        for (ModConfigurations modConfigs : Configs.CONFIGS) {
            for (AbstractConfiguration<?> config : modConfigs.configurations) {
                if (config.isClientSide()) continue;
                packagedConfigs.add(config);
            }
        }
        this.configs = Set.copyOf(packagedConfigs);
    }

    public PackagedConfigs(String json) {
        Configs.LOGGER.info("Received config sync packet");
        this.configs = new HashSet();
        JsonObject jsonObject = (JsonObject)JsonParser.parseString((String)json);
        if (jsonObject != null) {
            for (ModConfigurations modConfigs : Configs.CONFIGS) {
                for (AbstractConfiguration<?> config : modConfigs.configurations) {
                    if (jsonObject.get(config.getName()) == null) continue;
                    JsonElement element = jsonObject.get(config.getName());
                    this.configs.add(config.fromElement(element));
                }
            }
        }
    }

    public String toJsonString() {
        JsonObject jsonObject = new JsonObject();
        for (AbstractConfiguration<?> config : this.configs) {
            jsonObject.addProperty(config.getName(), config.valueToJson(false));
        }
        return jsonObject.toString();
    }

    public void updateServerConfigs() {
        for (ModConfigurations modConfigurations : Configs.CONFIGS) {
            for (AbstractConfiguration<?> config : modConfigurations.configurations) {
                config.getReloadableLoadedValue(false);
            }
        }
        block2: for (AbstractConfiguration abstractConfiguration : this.configs) {
            for (ModConfigurations modConfigs : Configs.CONFIGS) {
                if (!Objects.equals(modConfigs.modID, abstractConfiguration.modID)) continue;
                for (AbstractConfiguration<?> config : modConfigs.configurations) {
                    if (!Objects.equals(config.name, abstractConfiguration.name) || config.isClientSide()) continue;
                    config.setImportedValue(abstractConfiguration);
                    continue block2;
                }
            }
            Configs.LOGGER.warn("Received config " + abstractConfiguration.modID + ":" + abstractConfiguration.name + " which does not exist!");
        }
    }
}

