/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.pneumono.pneumonocore.PneumonoCore;
import net.pneumono.pneumonocore.config.AbstractConfiguration;
import net.pneumono.pneumonocore.config.Configs;
import net.pneumono.pneumonocore.datagen.AbstractConfigCondition;
import net.pneumono.pneumonocore.datagen.AndConfigCondition;
import net.pneumono.pneumonocore.datagen.ConfigCondition;
import net.pneumono.pneumonocore.datagen.NotConfigCondition;
import net.pneumono.pneumonocore.datagen.OrConfigCondition;
import net.pneumono.pneumonocore.datagen.enums.ConditionType;
import net.pneumono.pneumonocore.datagen.enums.Operator;

public class PneumonoDatagenHelper {
    public static ConditionJsonProvider configValues(final AbstractConfigCondition ... configs) {
        return new ConditionJsonProvider(){

            public class_2960 getConditionId() {
                return new class_2960("pneumonocore", "config_values");
            }

            public void writeParameters(JsonObject object) {
                JsonArray array = new JsonArray();
                for (AbstractConfigCondition condition : configs) {
                    array.add((JsonElement)condition.toJson());
                }
                object.add("conditions", (JsonElement)array);
            }
        };
    }

    public static void registerResourceConditions() {
        ResourceConditions.register((class_2960)new class_2960("pneumonocore", "config_values"), object -> {
            List jsonConditions = class_3518.method_15261((JsonObject)object, (String)"conditions").asList();
            ArrayList<AbstractConfigCondition> conditions = new ArrayList<AbstractConfigCondition>();
            for (JsonElement jsonCondition : jsonConditions) {
                conditions.add(PneumonoDatagenHelper.parseConditionJson(jsonCondition.getAsJsonObject()));
            }
            Supplier<Boolean> booleanSupplier = () -> PneumonoDatagenHelper.conditionsFulfilled(conditions.toArray(new AbstractConfigCondition[0]));
            return booleanSupplier.get();
        });
    }

    public static boolean conditionsFulfilled(AbstractConfigCondition ... conditions) {
        boolean fulfilled = true;
        for (AbstractConfigCondition condition : conditions) {
            if (condition.conditionFulfilled()) continue;
            fulfilled = false;
            break;
        }
        return fulfilled;
    }

    private static AbstractConfigCondition parseConditionJson(JsonObject object) {
        ConditionType type = ConditionType.fromString(class_3518.method_15265((JsonObject)object, (String)"type"));
        switch (type) {
            case AND: {
                List jsonConditions = class_3518.method_15261((JsonObject)object, (String)"conditions").asList();
                ArrayList<AbstractConfigCondition> conditions = new ArrayList<AbstractConfigCondition>();
                for (JsonElement jsonCondition : jsonConditions) {
                    conditions.add(PneumonoDatagenHelper.parseConditionJson(jsonCondition.getAsJsonObject()));
                }
                return new AndConfigCondition(conditions.toArray(new AbstractConfigCondition[0]));
            }
            case OR: {
                List jsonConditions = class_3518.method_15261((JsonObject)object, (String)"conditions").asList();
                ArrayList<AbstractConfigCondition> conditions = new ArrayList<AbstractConfigCondition>();
                for (JsonElement jsonCondition : jsonConditions) {
                    conditions.add(PneumonoDatagenHelper.parseConditionJson(jsonCondition.getAsJsonObject()));
                }
                return new OrConfigCondition(conditions.toArray(new AbstractConfigCondition[0]));
            }
            case NOT: {
                JsonElement jsonCondition = class_3518.method_52226((JsonObject)object, (String)"condition");
                return new NotConfigCondition(PneumonoDatagenHelper.parseConditionJson(jsonCondition.getAsJsonObject()));
            }
        }
        class_2960 configurationID = new class_2960(class_3518.method_15265((JsonObject)object, (String)"configuration"));
        AbstractConfiguration<?> configuration = Configs.getConfig(configurationID.method_12836(), configurationID.method_12832());
        if (configuration != null) {
            Operator operator = Operator.fromString(class_3518.method_15265((JsonObject)object, (String)"operator"));
            return new ConfigCondition(configuration.getID(), operator, configuration.valueFromElement(class_3518.method_52226((JsonObject)object, (String)"value")));
        }
        PneumonoCore.LOGGER.warn("Invalid resource condition JSON!");
        return null;
    }
}

