/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.skyboxathome.client.data;

import cn.zbx1425.skyboxathome.SkyboxAtHome;
import cn.zbx1425.skyboxathome.client.data.SkyboxProperty;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class SkyboxRegistry {
    public static final Map<String, SkyboxProperty> ELEMENTS = new HashMap<String, SkyboxProperty>();
    private static final SkyboxProperty DEFAULT_SKYBOX = new SkyboxProperty(new class_2960("skybox_athome", "textures/block/skybox.png"));

    public static void register(String key, SkyboxProperty property) {
        class_310.method_1551().method_1531().method_4619(property.texture).method_4527(true, false);
        ELEMENTS.put(key, property);
    }

    public static SkyboxProperty getOrDefault(String key) {
        return ELEMENTS.getOrDefault(key, DEFAULT_SKYBOX);
    }

    public static void loadResources(class_3300 manager) {
        ELEMENTS.clear();
        List<Pair<class_2960, class_3298>> resources = SkyboxRegistry.listResources(manager, "skybox_athome", "skyboxes", ".json");
        for (Pair<class_2960, class_3298> pair : resources) {
            try {
                InputStream is = ((class_3298)pair.getSecond()).method_14482();
                try {
                    JsonObject rootObj = JsonParser.parseString((String)IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8)).getAsJsonObject();
                    if (rootObj.has("texture")) {
                        String key = FilenameUtils.getBaseName((String)((class_2960)pair.getFirst()).method_12832()).toLowerCase(Locale.ROOT);
                        SkyboxRegistry.register(key, new SkyboxProperty(rootObj));
                        continue;
                    }
                    for (Map.Entry entry : rootObj.entrySet()) {
                        JsonObject obj = ((JsonElement)entry.getValue()).getAsJsonObject();
                        String key = ((String)entry.getKey()).toLowerCase(Locale.ROOT);
                        SkyboxRegistry.register(key, new SkyboxProperty(obj));
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception ex) {
                SkyboxAtHome.LOGGER.error("Failed loading rail: " + ((class_2960)pair.getFirst()).toString(), (Throwable)ex);
            }
        }
    }

    private static List<Pair<class_2960, class_3298>> listResources(class_3300 resourceManager, String namespace, String path, String extension) {
        return resourceManager.method_41265(path, rl -> rl.method_12836().equals(namespace) && rl.method_12832().endsWith(extension)).entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(r -> new Pair((Object)((class_2960)e.getKey()), r))).toList();
    }
}

