/*
 * Decompiled with CFR 0.152.
 */
package com.golem.stackabletrims.core;

import com.golem.stackabletrims.component.StackableTrimsComponents;
import com.golem.stackabletrims.core.TrimPolicy;
import com.golem.stackabletrims.core.TrimStackService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;

public class DefaultTrimStackService
implements TrimStackService {
    @Override
    public Optional<List<ArmorTrim>> getTrims(ItemStack stack) {
        if (!stack.is(ItemTags.TRIMMABLE_ARMOR)) {
            return Optional.empty();
        }
        List trims = (List)stack.get(StackableTrimsComponents.STACKABLETRIMS);
        if (trims == null || trims.isEmpty()) {
            ArmorTrim singleTrim = (ArmorTrim)stack.get(DataComponents.TRIM);
            if (singleTrim != null) {
                return Optional.of(List.of(singleTrim));
            }
            return Optional.empty();
        }
        return Optional.of(new ArrayList(trims));
    }

    @Override
    public boolean addTrim(ItemStack stack, ArmorTrim newTrim, int maxStack) {
        if (!stack.is(ItemTags.TRIMMABLE_ARMOR)) {
            return false;
        }
        List currentTrims = (List)stack.get(StackableTrimsComponents.STACKABLETRIMS);
        if (currentTrims == null || currentTrims.isEmpty()) {
            ArmorTrim singleTrim = (ArmorTrim)stack.get(DataComponents.TRIM);
            List<Object> list = currentTrims = singleTrim != null ? new ArrayList<ArmorTrim>(List.of(singleTrim)) : new ArrayList();
        }
        if (currentTrims.size() >= maxStack) {
            return false;
        }
        ArrayList<ArmorTrim> newTrims = new ArrayList<ArmorTrim>(currentTrims);
        newTrims.add(newTrim);
        stack.set(StackableTrimsComponents.STACKABLETRIMS, newTrims);
        stack.set(DataComponents.TRIM, (Object)newTrim);
        return true;
    }

    @Override
    public Optional<ArmorTrim> getLast(ItemStack stack) {
        return this.getTrims(stack).filter(trims -> !trims.isEmpty()).map(trims -> (ArmorTrim)trims.get(trims.size() - 1));
    }

    @Override
    public boolean hasTrim(ItemStack stack, ArmorTrim trim) {
        return this.getTrims(stack).map(trims -> trims.stream().anyMatch(t -> t.equals((Object)trim))).orElse(false);
    }

    @Override
    public void removeTrims(ItemStack stack, int count) {
        List currentTrims = (List)stack.getOrDefault(StackableTrimsComponents.STACKABLETRIMS, new ArrayList());
        if (currentTrims.isEmpty()) {
            return;
        }
        ArrayList newTrims = new ArrayList(currentTrims);
        int toRemove = Math.min(count, newTrims.size());
        for (int i = 0; i < toRemove; ++i) {
            if (newTrims.isEmpty()) continue;
            newTrims.removeLast();
        }
        if (newTrims.isEmpty()) {
            stack.remove(StackableTrimsComponents.STACKABLETRIMS);
            stack.remove(DataComponents.TRIM);
        } else {
            stack.set(StackableTrimsComponents.STACKABLETRIMS, newTrims);
            stack.set(DataComponents.TRIM, (Object)((ArmorTrim)newTrims.getLast()));
        }
    }

    @Override
    public int getTrimCount(ItemStack stack) {
        return this.getTrims(stack).map(List::size).orElse(0);
    }

    @Override
    public boolean canAdd(ItemStack stack, ArmorTrim newTrim, TrimPolicy policy) {
        if (!stack.is(ItemTags.TRIMMABLE_ARMOR)) {
            return false;
        }
        int max = policy.getMaxStack();
        if (max == 0) {
            return false;
        }
        if (this.getTrimCount(stack) >= max) {
            return false;
        }
        return policy.allowDuplicates() || !this.hasTrim(stack, newTrim);
    }
}

