/*
 * Decompiled with CFR 0.152.
 */
package com.golem.stackabletrims.core;

import com.golem.stackabletrims.core.CoreServices;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;

public final class TrimTooltipComposer {
    private static final Component UPGRADE_TEXT = Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"smithing_template.upgrade"))).withStyle(ChatFormatting.GRAY);
    private static final String UPGRADE_KEY = Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"smithing_template.upgrade"));

    private TrimTooltipComposer() {
    }

    public static void compose(ItemStack stack, List<Component> tooltip) {
        CoreServices.trims().getTrims(stack).ifPresent(trims -> {
            if (trims.isEmpty()) {
                return;
            }
            int insertIndex = -1;
            for (int i = 0; i < tooltip.size(); ++i) {
                TranslatableContents tc;
                Component c = (Component)tooltip.get(i);
                ComponentContents patt0$temp = c.getContents();
                if (!(patt0$temp instanceof TranslatableContents) || !UPGRADE_KEY.equals((tc = (TranslatableContents)patt0$temp).getKey())) continue;
                insertIndex = i;
                tooltip.remove(i);
                if (i < tooltip.size()) {
                    tooltip.remove(i);
                }
                if (i >= tooltip.size()) break;
                tooltip.remove(i);
                break;
            }
            ArrayList<Object> newLines = new ArrayList<Object>();
            newLines.add(UPGRADE_TEXT);
            for (ArmorTrim trim : trims) {
                newLines.add(CommonComponents.space().append(((TrimPattern)trim.pattern().value()).copyWithStyle(trim.material())));
                newLines.add(CommonComponents.space().append(((TrimMaterial)trim.material().value()).description()));
            }
            if (insertIndex >= 0) {
                tooltip.addAll(insertIndex, newLines);
            } else {
                tooltip.addAll(newLines);
            }
        });
    }
}

