/*
 * Decompiled with CFR 0.152.
 */
package com.golem.stackabletrims.neoforge;

import com.golem.stackabletrims.StackableTrims;
import com.golem.stackabletrims.component.StackableTrimsComponents;
import com.golem.stackabletrims.core.GameRuleTrimPolicyResolver;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.level.GameRules;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="stackabletrims")
public class StackableTrimsNeoForge {
    private static final DeferredRegister<DataComponentType<?>> COMPONENTS = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"stackabletrims");
    private static final DeferredHolder<DataComponentType<?>, DataComponentType<List<ArmorTrim>>> STACKABLETRIMS_COMPONENT = COMPONENTS.register("stackabletrims", StackableTrimsComponents::createStackableTrimsComponent);

    public StackableTrimsNeoForge(IEventBus modEventBus) {
        StackableTrims.init();
        COMPONENTS.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.addListener(this::onServerTick);
        StackableTrims.setIsBetterTrimTooltipsEnabled(ModList.get().isLoaded("better-trim-tooltips"));
        StackableTrims.LOGGER.info("Stackable Trims NeoForge initialized");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        StackableTrimsComponents.STACKABLETRIMS = (DataComponentType)STACKABLETRIMS_COMPONENT.get();
        event.enqueueWork(() -> {
            GameRuleTrimPolicyResolver.MAX_TRIM_STACK = GameRules.register((String)"maxTrimStack", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.IntegerValue.create((int)32));
            GameRuleTrimPolicyResolver.ALLOW_DUPLICATE_TRIMS = GameRules.register((String)"allowDuplicateTrims", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.BooleanValue.create((boolean)false));
        });
    }

    private void onServerTick(ServerTickEvent.Post event) {
        StackableTrims.setGameRules(event.getServer().getGameRules());
    }

    public static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }
}

