/*
 * Decompiled with CFR 0.152.
 */
package com.golem.stackabletrims.core;

import com.golem.stackabletrims.component.StackableTrimsComponents;
import com.golem.stackabletrims.core.TrimPolicy;
import com.golem.stackabletrims.core.TrimStackService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_3489;
import net.minecraft.class_8053;
import net.minecraft.class_9334;

public class DefaultTrimStackService
implements TrimStackService {
    @Override
    public Optional<List<class_8053>> getTrims(class_1799 stack) {
        if (!stack.method_31573(class_3489.field_41890)) {
            return Optional.empty();
        }
        List trims = (List)stack.method_57824(StackableTrimsComponents.STACKABLETRIMS);
        if (trims == null || trims.isEmpty()) {
            class_8053 singleTrim = (class_8053)stack.method_57824(class_9334.field_49607);
            if (singleTrim != null) {
                return Optional.of(List.of(singleTrim));
            }
            return Optional.empty();
        }
        return Optional.of(new ArrayList(trims));
    }

    @Override
    public boolean addTrim(class_1799 stack, class_8053 newTrim, int maxStack) {
        if (!stack.method_31573(class_3489.field_41890)) {
            return false;
        }
        List currentTrims = (List)stack.method_57824(StackableTrimsComponents.STACKABLETRIMS);
        if (currentTrims == null || currentTrims.isEmpty()) {
            class_8053 singleTrim = (class_8053)stack.method_57824(class_9334.field_49607);
            List<Object> list = currentTrims = singleTrim != null ? new ArrayList<class_8053>(List.of(singleTrim)) : new ArrayList();
        }
        if (currentTrims.size() >= maxStack) {
            return false;
        }
        ArrayList<class_8053> newTrims = new ArrayList<class_8053>(currentTrims);
        newTrims.add(newTrim);
        stack.method_57379(StackableTrimsComponents.STACKABLETRIMS, newTrims);
        stack.method_57379(class_9334.field_49607, (Object)newTrim);
        return true;
    }

    @Override
    public Optional<class_8053> getLast(class_1799 stack) {
        return this.getTrims(stack).filter(trims -> !trims.isEmpty()).map(trims -> (class_8053)trims.get(trims.size() - 1));
    }

    @Override
    public boolean hasTrim(class_1799 stack, class_8053 trim) {
        return this.getTrims(stack).map(trims -> trims.stream().anyMatch(t -> t.equals((Object)trim))).orElse(false);
    }

    @Override
    public void removeTrims(class_1799 stack, int count) {
        List currentTrims = (List)stack.method_57825(StackableTrimsComponents.STACKABLETRIMS, new ArrayList());
        if (currentTrims.isEmpty()) {
            return;
        }
        ArrayList newTrims = new ArrayList(currentTrims);
        int toRemove = Math.min(count, newTrims.size());
        for (int i = 0; i < toRemove; ++i) {
            if (newTrims.isEmpty()) continue;
            newTrims.removeLast();
        }
        if (newTrims.isEmpty()) {
            stack.method_57381(StackableTrimsComponents.STACKABLETRIMS);
            stack.method_57381(class_9334.field_49607);
        } else {
            stack.method_57379(StackableTrimsComponents.STACKABLETRIMS, newTrims);
            stack.method_57379(class_9334.field_49607, (Object)((class_8053)newTrims.getLast()));
        }
    }

    @Override
    public int getTrimCount(class_1799 stack) {
        return this.getTrims(stack).map(List::size).orElse(0);
    }

    @Override
    public boolean canAdd(class_1799 stack, class_8053 newTrim, TrimPolicy policy) {
        if (!stack.method_31573(class_3489.field_41890)) {
            return false;
        }
        int max = policy.getMaxStack();
        if (max == 0) {
            return false;
        }
        if (this.getTrimCount(stack) >= max) {
            return false;
        }
        return policy.allowDuplicates() || !this.hasTrim(stack, newTrim);
    }
}

