/*
 * Decompiled with CFR 0.152.
 */
package com.golem.stackabletrims.mixin;

import com.golem.stackabletrims.core.CoreServices;
import com.golem.stackabletrims.core.TrimPolicy;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_8062;
import net.minecraft.class_9697;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_8062.class})
public class SmithingTrimRecipeMixin {
    @Inject(method={"matches(Lnet/minecraft/world/item/crafting/SmithingRecipeInput;Lnet/minecraft/world/level/Level;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void denyWhenAtOrOverLimit(class_9697 input, class_1937 level, CallbackInfoReturnable<Boolean> cir) {
        TrimPolicy policy = CoreServices.policyResolver().forLevel(level);
        if (policy.getMaxStack() == 0) {
            cir.setReturnValue((Object)false);
            return;
        }
        class_1799 baseStack = input.comp_2678();
        if (CoreServices.trims().getTrimCount(baseStack) >= policy.getMaxStack()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"assemble(Lnet/minecraft/world/item/crafting/SmithingRecipeInput;Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;get(Lnet/minecraft/core/component/DataComponentType;)Ljava/lang/Object;")}, cancellable=true)
    public void handleStackableTrims(class_9697 input, class_7225.class_7874 registries, CallbackInfoReturnable<class_1799> cir, @Local class_1799 baseStack, @Local(ordinal=0) Optional<class_6880.class_6883<class_8054>> materialOpt, @Local(ordinal=1) Optional<class_6880.class_6883<class_8056>> patternOpt) {
        if (materialOpt.isEmpty() || patternOpt.isEmpty()) {
            return;
        }
        class_8053 newTrim = new class_8053((class_6880)materialOpt.get(), (class_6880)patternOpt.get());
        TrimPolicy policy = CoreServices.policyResolver().forLevel(null);
        if (!CoreServices.trims().canAdd(baseStack, newTrim, policy)) {
            cir.setReturnValue((Object)class_1799.field_8037);
            return;
        }
        class_1799 result = baseStack.method_46651(1);
        if (CoreServices.trims().addTrim(result, newTrim, policy.getMaxStack())) {
            cir.setReturnValue((Object)result);
        } else {
            cir.setReturnValue((Object)class_1799.field_8037);
        }
    }
}

