/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.common.config;

import net.povstalec.stellarview.common.config.StellarViewConfigSpec;

public abstract class StellarViewConfigValue {

    public static class RGBAValue {
        public StellarViewConfigSpec.IntValue red_value;
        public StellarViewConfigSpec.IntValue green_value;
        public StellarViewConfigSpec.IntValue blue_value;
        public StellarViewConfigSpec.IntValue alpha_value;

        public RGBAValue(StellarViewConfigSpec.Builder builder, String path, int red, int blue, int green, int alpha, String comment) {
            builder.comment(comment);
            this.red_value = builder.defineInRange(path + ".red", red, 0, 255);
            this.green_value = builder.defineInRange(path + ".green", blue, 0, 255);
            this.blue_value = builder.defineInRange(path + ".blue", green, 0, 255);
            this.alpha_value = builder.defineInRange(path + ".alpha", alpha, 0, 255);
        }

        public void setRed(int value) {
            this.red_value.set(value);
            this.red_value.save();
        }

        public void setGreen(int value) {
            this.green_value.set(value);
            this.green_value.save();
        }

        public void setBlue(int value) {
            this.blue_value.set(value);
            this.blue_value.save();
        }

        public void setAlpha(int value) {
            this.alpha_value.set(value);
            this.alpha_value.save();
        }

        public int getRed() {
            return (Integer)this.red_value.get();
        }

        public int getGreen() {
            return (Integer)this.green_value.get();
        }

        public int getBlue() {
            return (Integer)this.blue_value.get();
        }

        public int getAlpha() {
            return (Integer)this.alpha_value.get();
        }

        public int getRedDefault() {
            return (Integer)this.red_value.getDefault();
        }

        public int getGreenDefault() {
            return (Integer)this.green_value.getDefault();
        }

        public int getBlueDefault() {
            return (Integer)this.blue_value.getDefault();
        }

        public int getAlphaDefault() {
            return (Integer)this.alpha_value.getDefault();
        }
    }

    public static class IntValue {
        public StellarViewConfigSpec.IntValue int_value;
        protected int min;
        protected int max;

        public IntValue(StellarViewConfigSpec.Builder builder, String path, int defaultValue, int min, int max, String comment) {
            this.int_value = builder.comment(comment).defineInRange(path, defaultValue, min, max);
            this.min = min;
            this.max = max;
        }

        public void set(int value) {
            this.int_value.set(value);
            this.int_value.save();
        }

        public int get() {
            return (Integer)this.int_value.get();
        }

        public int getDefault() {
            return (Integer)this.int_value.getDefault();
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }
    }

    public static class BooleanValue {
        public StellarViewConfigSpec.BooleanValue boolean_value;

        public BooleanValue(StellarViewConfigSpec.Builder builder, String path, boolean defaultValue, String comment) {
            this.boolean_value = builder.comment(comment).define(path, defaultValue);
        }

        public void set(boolean value) {
            this.boolean_value.set((Object)value);
            this.boolean_value.save();
        }

        public boolean get() {
            return (Boolean)this.boolean_value.get();
        }

        public boolean getDefault() {
            return (Boolean)this.boolean_value.getDefault();
        }
    }
}

