/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.api.common.space_objects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_7833;
import net.povstalec.stellarview.api.common.space_objects.SpaceObject;
import net.povstalec.stellarview.api.common.space_objects.TexturedObject;
import net.povstalec.stellarview.common.config.GeneralConfig;
import net.povstalec.stellarview.common.util.AxisRotation;
import net.povstalec.stellarview.common.util.ISerializable;
import net.povstalec.stellarview.common.util.SpaceCoords;
import net.povstalec.stellarview.common.util.StellarCoordinates;
import net.povstalec.stellarview.common.util.TextureLayer;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class OrbitingObject
extends TexturedObject {
    public static final String ORBIT_INFO = "orbit_info";
    public static final Vector3f INITIAL_ORBIT_VECTOR = new Vector3f(-1.0f, 0.0f, 0.0f);
    @Nullable
    private OrbitInfo orbitInfo;
    public static final Codec<OrbitingObject> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SpaceObject.ParentInfo.CODEC.optionalFieldOf("parent").forGetter(SpaceObject::getParentInfo), (App)Codec.either(SpaceCoords.CODEC, StellarCoordinates.Equatorial.CODEC).fieldOf("coords").forGetter(object -> Either.left((Object)object.getCoords())), (App)AxisRotation.CODEC.fieldOf("axis_rotation").forGetter(SpaceObject::getAxisRotation), (App)OrbitInfo.CODEC.optionalFieldOf(ORBIT_INFO).forGetter(object -> Optional.ofNullable(object.orbitInfo)), (App)TextureLayer.CODEC.listOf().fieldOf("texture_layers").forGetter(TexturedObject::getTextureLayers), (App)TexturedObject.FadeOutHandler.CODEC.optionalFieldOf("fade_out_handler", (Object)TexturedObject.FadeOutHandler.DEFAULT_PLANET_HANDLER).forGetter(TexturedObject::getFadeOutHandler)).apply((Applicative)instance, OrbitingObject::new));

    public OrbitingObject() {
    }

    public OrbitingObject(Optional<SpaceObject.ParentInfo> parent, Either<SpaceCoords, StellarCoordinates.Equatorial> coords, AxisRotation axisRotation, Optional<OrbitInfo> orbitInfo, List<TextureLayer> textureLayers, TexturedObject.FadeOutHandler fadeOutHandler) {
        super(parent, coords, axisRotation, textureLayers, fadeOutHandler);
        if (orbitInfo.isPresent()) {
            this.orbitInfo = orbitInfo.get();
        }
    }

    @Nullable
    public OrbitInfo orbitInfo() {
        return this.orbitInfo;
    }

    public void setupSynodicOrbit(@Nullable OrbitalPeriod parentOrbitalPeriod) {
        if (this.orbitInfo() != null) {
            this.orbitInfo().orbitalPeriod().updateFromParentPeriod(parentOrbitalPeriod);
            this.orbitInfo().setupSweep();
            for (SpaceObject child : this.children) {
                if (!(child instanceof OrbitingObject)) continue;
                OrbitingObject orbitingObject = (OrbitingObject)child;
                orbitingObject.setupSynodicOrbit(this.orbitInfo().orbitalPeriod());
            }
        } else {
            for (SpaceObject child : this.children) {
                if (!(child instanceof OrbitingObject)) continue;
                OrbitingObject orbitingObject = (OrbitingObject)child;
                orbitingObject.setupSynodicOrbit(null);
            }
        }
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 tag = super.serializeNBT();
        if (this.orbitInfo != null) {
            tag.method_10566(ORBIT_INFO, (class_2520)this.orbitInfo.serializeNBT());
        }
        return tag;
    }

    @Override
    public void deserializeNBT(class_2487 tag) {
        super.deserializeNBT(tag);
        if (tag.method_10545(ORBIT_INFO)) {
            this.orbitInfo = new OrbitInfo();
            this.orbitInfo.deserializeNBT(tag.method_10562(ORBIT_INFO));
        } else {
            this.orbitInfo = null;
        }
    }

    public static class OrbitInfo
    implements ISerializable {
        public static final String APOAPSIS = "apoapsis";
        public static final String PERIAPSIS = "periapsis";
        public static final String ORBIT_CLAMP_DISTANCE = "orbit_clamp_distance";
        public static final String ORBITAL_PERIOD = "orbital_period";
        public static final String ARGUMENT_OF_PERIAPSIS = "argument_of_periapsis";
        public static final String INCLINATION = "inclination";
        public static final String LONGITUDE_OF_ASCENDING_NODE = "longitude_of_ascending_node";
        public static final String EPOCH_MEAN_ANOMALY = "epoch_mean_anomaly";
        public static final Codec<OrbitInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)1.0f, (float)Float.MAX_VALUE).fieldOf(APOAPSIS).forGetter(OrbitInfo::apoapsis), (App)Codec.floatRange((float)1.0f, (float)Float.MAX_VALUE).fieldOf(PERIAPSIS).forGetter(OrbitInfo::periapsis), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf(ORBIT_CLAMP_DISTANCE, (Object)Float.valueOf(0.0f)).forGetter(OrbitInfo::orbitClampNumber), (App)OrbitalPeriod.CODEC.fieldOf(ORBITAL_PERIOD).forGetter(OrbitInfo::orbitalPeriod), (App)Codec.FLOAT.optionalFieldOf(ARGUMENT_OF_PERIAPSIS, (Object)Float.valueOf(0.0f)).forGetter(OrbitInfo::argumentOfPeriapsis), (App)Codec.FLOAT.optionalFieldOf(INCLINATION, (Object)Float.valueOf(0.0f)).forGetter(OrbitInfo::inclination), (App)Codec.FLOAT.optionalFieldOf(LONGITUDE_OF_ASCENDING_NODE, (Object)Float.valueOf(0.0f)).forGetter(OrbitInfo::longtitudeOfAscendingNode), (App)Codec.FLOAT.optionalFieldOf(EPOCH_MEAN_ANOMALY, (Object)Float.valueOf(0.0f)).forGetter(OrbitInfo::epochMeanAnomaly)).apply((Applicative)instance, OrbitInfo::new));
        private float apoapsis;
        private float periapsis;
        private float orbitClampDistance;
        private OrbitalPeriod orbitalPeriod;
        private float argumentOfPeriapsis;
        private float inclination;
        private float longitudeOfAscendingNode;
        private float epochMeanAnomaly;
        private float sweep;
        private float eccentricity;
        private Matrix4f orbitMatrix;

        public OrbitInfo() {
        }

        public OrbitInfo(float apoapsis, float periapsis, float orbitClampDistance, OrbitalPeriod orbitalPeriod, float argumentOfPeriapsis, float inclination, float longitudeOfAscendingNode, float meanAnomaly) {
            this.apoapsis = apoapsis;
            this.periapsis = periapsis;
            this.orbitClampDistance = orbitClampDistance;
            this.orbitalPeriod = orbitalPeriod;
            this.argumentOfPeriapsis = (float)Math.toRadians(argumentOfPeriapsis);
            this.inclination = (float)Math.toRadians(inclination);
            this.longitudeOfAscendingNode = (float)Math.toRadians(longitudeOfAscendingNode);
            this.epochMeanAnomaly = (float)Math.toRadians(meanAnomaly);
            this.setupSweep();
            this.eccentricity = (apoapsis - periapsis) / (apoapsis + periapsis);
            this.orbitMatrix = this.orbitMatrix();
        }

        public float apoapsis() {
            return this.apoapsis;
        }

        public float periapsis() {
            return this.periapsis;
        }

        public float orbitClampNumber() {
            return this.orbitClampDistance;
        }

        public void setupSweep() {
            this.sweep = (float)(Math.PI * 2 * this.orbitalPeriod().frequency());
        }

        public OrbitalPeriod orbitalPeriod() {
            return this.orbitalPeriod;
        }

        public float argumentOfPeriapsis() {
            return this.argumentOfPeriapsis;
        }

        public float inclination() {
            return this.inclination;
        }

        public float longtitudeOfAscendingNode() {
            return this.longitudeOfAscendingNode;
        }

        public float epochMeanAnomaly() {
            return this.epochMeanAnomaly;
        }

        public float eccentricity() {
            return this.eccentricity;
        }

        public Vector3f getOrbitVector(long ticks, float partialTicks) {
            Vector3f orbitVector = new Vector3f((Vector3fc)INITIAL_ORBIT_VECTOR);
            float trueAnomaly = (float)this.eccentricAnomaly(ticks, partialTicks);
            orbitVector.mulProject((Matrix4fc)this.movementMatrix(trueAnomaly));
            orbitVector.mulProject((Matrix4fc)this.getOrbitMatrix());
            return orbitVector;
        }

        public Vector3f getOrbitVector(long ticks, float partialTicks, double distance) {
            if (this.orbitClampDistance > 0.0f && distance > (double)this.orbitClampDistance) {
                float mul = (float)distance / this.orbitClampDistance;
                return this.getOrbitVector(ticks, partialTicks).mulProject((Matrix4fc)new Matrix4f().scale(mul, mul, mul));
            }
            return this.getOrbitVector(ticks, partialTicks);
        }

        public double meanAnomaly(long ticks, float partialTicks) {
            return this.epochMeanAnomaly + this.sweep * ((float)(ticks - (long)GeneralConfig.tick_multiplier.get()) + partialTicks);
        }

        public double eccentricAnomaly(long ticks, float partialTicks) {
            return OrbitInfo.approximateEccentricAnomaly(this.eccentricity, this.meanAnomaly(ticks % this.orbitalPeriod().ticks(), partialTicks), 4);
        }

        public Matrix4f movementMatrix(float orbitProgress) {
            return new Matrix4f().rotate((Quaternionfc)class_7833.field_40716.rotation(orbitProgress));
        }

        public Matrix4f orbitMatrix() {
            float semiMajorAxis = (this.apoapsis + this.periapsis) / 2.0f;
            Matrix4f scaleMatrix = new Matrix4f().scale(semiMajorAxis, semiMajorAxis, semiMajorAxis);
            Matrix4f eccentricityMatrix = new Matrix4f().scale(1.0f, 1.0f, 1.0f - this.eccentricity());
            Matrix4f offsetMatrix = new Matrix4f().translate((Vector3fc)new Vector3f(semiMajorAxis - this.periapsis, 0.0f, 0.0f));
            Matrix4f periapsisMatrix = new Matrix4f().rotate((Quaternionfc)class_7833.field_40716.rotation(this.argumentOfPeriapsis));
            Matrix4f inclinationMatrix = new Matrix4f().rotate((Quaternionfc)class_7833.field_40718.rotation(this.inclination));
            Matrix4f ascensionMatrix = new Matrix4f().rotate((Quaternionfc)class_7833.field_40716.rotation(this.longitudeOfAscendingNode));
            return ascensionMatrix.mul((Matrix4fc)inclinationMatrix).mul((Matrix4fc)periapsisMatrix).mul((Matrix4fc)offsetMatrix).mul((Matrix4fc)eccentricityMatrix).mul((Matrix4fc)scaleMatrix);
        }

        public Matrix4f getOrbitMatrix() {
            return this.orbitMatrix;
        }

        @Override
        public class_2487 serializeNBT() {
            class_2487 tag = new class_2487();
            tag.method_10548(APOAPSIS, this.apoapsis);
            tag.method_10548(PERIAPSIS, this.periapsis);
            tag.method_10548(ORBIT_CLAMP_DISTANCE, this.orbitClampDistance);
            tag.method_10566(ORBITAL_PERIOD, (class_2520)this.orbitalPeriod.serializeNBT());
            tag.method_10548(ARGUMENT_OF_PERIAPSIS, this.argumentOfPeriapsis);
            tag.method_10548(INCLINATION, this.inclination);
            tag.method_10548(LONGITUDE_OF_ASCENDING_NODE, this.longitudeOfAscendingNode);
            tag.method_10548(EPOCH_MEAN_ANOMALY, this.epochMeanAnomaly);
            return tag;
        }

        @Override
        public void deserializeNBT(class_2487 tag) {
            this.apoapsis = tag.method_10583(APOAPSIS);
            this.periapsis = tag.method_10583(PERIAPSIS);
            this.orbitClampDistance = tag.method_10583(ORBIT_CLAMP_DISTANCE);
            this.orbitalPeriod = new OrbitalPeriod();
            this.orbitalPeriod.deserializeNBT(tag.method_10562(ORBITAL_PERIOD));
            this.argumentOfPeriapsis = tag.method_10583(ARGUMENT_OF_PERIAPSIS);
            this.inclination = tag.method_10583(INCLINATION);
            this.longitudeOfAscendingNode = tag.method_10583(LONGITUDE_OF_ASCENDING_NODE);
            this.epochMeanAnomaly = tag.method_10583(EPOCH_MEAN_ANOMALY);
            this.setupSweep();
            this.eccentricity = (this.apoapsis - this.periapsis) / (this.apoapsis + this.periapsis);
            this.orbitMatrix = this.orbitMatrix();
        }

        public static double approximateEccentricAnomaly(double eccentricity, double meanAnomaly, int iterations) {
            double sinMeanAnomaly = Math.sin(meanAnomaly);
            double E = meanAnomaly + eccentricity * (sinMeanAnomaly / (1.0 - Math.sin(meanAnomaly + eccentricity) + sinMeanAnomaly));
            for (int i = 0; i < iterations; ++i) {
                E -= (E - eccentricity * Math.sin(E) - meanAnomaly) / (1.0 - eccentricity * Math.cos(E));
            }
            return E;
        }
    }

    public static class OrbitalPeriod
    implements ISerializable {
        public static final String TICKS = "ticks";
        public static final String ORBITS = "orbits";
        public static final String SYNODIC = "synodic";
        private long ticks;
        private double orbits;
        private boolean synodic;
        private double frequency;
        public static final Codec<OrbitalPeriod> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf(TICKS).forGetter(OrbitalPeriod::ticks), (App)Codec.doubleRange((double)Double.MIN_NORMAL, (double)Double.MAX_VALUE).optionalFieldOf(ORBITS, (Object)1.0).forGetter(OrbitalPeriod::orbits), (App)Codec.BOOL.optionalFieldOf(SYNODIC, (Object)false).forGetter(OrbitalPeriod::synodic)).apply((Applicative)instance, OrbitalPeriod::new));

        public OrbitalPeriod() {
        }

        public OrbitalPeriod(long ticks, double orbits, boolean synodic) {
            if (ticks <= 0L) {
                throw new IllegalArgumentException("Value ticks outside of range [1:2147483647]");
            }
            this.ticks = ticks;
            this.orbits = orbits;
            this.synodic = synodic;
            this.frequency = orbits / (double)ticks;
        }

        public void updateFromParentPeriod(OrbitalPeriod parentPeriod) {
            if (!this.synodic || parentPeriod == null) {
                return;
            }
            this.ticks = parentPeriod.ticks;
            this.orbits = this.frequency * (double)this.ticks + 1.0;
            this.frequency = this.orbits / (double)this.ticks;
            this.synodic = false;
        }

        public long ticks() {
            return this.ticks;
        }

        public double orbits() {
            return this.orbits;
        }

        public boolean synodic() {
            return this.synodic;
        }

        public double frequency() {
            return this.frequency;
        }

        @Override
        public class_2487 serializeNBT() {
            class_2487 tag = new class_2487();
            tag.method_10544(TICKS, this.ticks);
            tag.method_10549(ORBITS, this.orbits);
            tag.method_10556(SYNODIC, this.synodic);
            return tag;
        }

        @Override
        public void deserializeNBT(class_2487 tag) {
            this.ticks = tag.method_10537(TICKS);
            this.orbits = tag.method_10574(ORBITS);
            this.synodic = tag.method_10577(SYNODIC);
            this.frequency = this.orbits / (double)this.ticks;
        }
    }
}

