/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import net.minecraft.class_286;
import net.minecraft.class_311;
import net.minecraft.class_5944;
import net.povstalec.stellarview.client.render.SpaceRenderer;
import net.povstalec.stellarview.client.render.shader.CelestialShaderInstance;
import net.povstalec.stellarview.common.util.SpaceCoords;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.opengl.GL31C;
import org.lwjgl.opengl.GL43C;

public class CelestialInstancedBuffer
implements AutoCloseable {
    public static final int POS_SIZE = 3;
    public static final int COLOR_SIZE = 4;
    public static final int ROTATION_SIZE = 1;
    public static final int SIZE_SIZE = 1;
    public static final int MAX_DISTANCE_SIZE = 1;
    public static final int INSTANCE_SIZE = 10;
    public static final float[] STAR_VERTICES = new float[]{-1.0f, -1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, -1.0f, 0.0f};
    public static final float[] STAR_TEX_VERTICES = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f};
    public static final ByteBuffer INDEX_BUFFER = CelestialInstancedBuffer.indexBuffer();
    private int instanceBufferId;
    private int vertexBufferId;
    private int indexBufferId;
    private int arrayObjectId;

    public CelestialInstancedBuffer() {
        RenderSystem.assertOnRenderThread();
        this.instanceBufferId = GlStateManager._glGenBuffers();
        this.vertexBufferId = GlStateManager._glGenBuffers();
        this.indexBufferId = GlStateManager._glGenBuffers();
        this.arrayObjectId = GlStateManager._glGenVertexArrays();
    }

    public static ByteBuffer indexBuffer() {
        ByteBuffer instanceBuffer = class_311.method_1596((int)6);
        instanceBuffer.put(0, (byte)0);
        instanceBuffer.put(1, (byte)1);
        instanceBuffer.put(2, (byte)2);
        instanceBuffer.put(3, (byte)2);
        instanceBuffer.put(4, (byte)3);
        instanceBuffer.put(5, (byte)0);
        return instanceBuffer;
    }

    private static void attribute(int index, int size, int stride, int offset) {
        GL20C.glEnableVertexAttribArray((int)index);
        GL20C.glVertexAttribPointer((int)index, (int)size, (int)5126, (boolean)false, (int)stride, (long)offset);
        GL43C.glVertexBindingDivisor((int)index, (int)1);
    }

    public void upload(float[] instances, boolean hasTexture) {
        GL15C.glBindBuffer((int)34962, (int)this.instanceBufferId);
        GL15C.glBufferData((int)34962, (float[])instances, (int)35044);
        GL15C.glBindBuffer((int)34962, (int)0);
        GL30C.glBindVertexArray((int)this.arrayObjectId);
        GL15C.glBindBuffer((int)34962, (int)this.vertexBufferId);
        GL15.glBufferData((int)34962, (float[])(hasTexture ? STAR_TEX_VERTICES : STAR_VERTICES), (int)35044);
        GL15.glBindBuffer((int)34963, (int)this.indexBufferId);
        GL15.glBufferData((int)34963, (ByteBuffer)INDEX_BUFFER, (int)35044);
        GL20C.glEnableVertexAttribArray((int)0);
        GL20C.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)(hasTexture ? 20 : 12), (long)0L);
        if (hasTexture) {
            GL20C.glEnableVertexAttribArray((int)1);
            GL20C.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)20, (long)12L);
        }
        int attributeStart = hasTexture ? 2 : 1;
        GL15.glBindBuffer((int)34962, (int)this.instanceBufferId);
        CelestialInstancedBuffer.attribute(attributeStart, 3, 40, 0);
        CelestialInstancedBuffer.attribute(attributeStart + 1, 4, 40, 12);
        CelestialInstancedBuffer.attribute(attributeStart + 2, 1, 40, 28);
        CelestialInstancedBuffer.attribute(attributeStart + 3, 1, 40, 32);
        CelestialInstancedBuffer.attribute(attributeStart + 4, 1, 40, 36);
        GL15.glBindBuffer((int)34962, (int)0);
        GL30C.glBindVertexArray((int)0);
        GL15C.glBindBuffer((int)34963, (int)0);
    }

    public void bind() {
        class_286.method_43436();
        GlStateManager._glBindVertexArray((int)this.arrayObjectId);
    }

    public static void unbind() {
        class_286.method_43436();
        GlStateManager._glBindVertexArray((int)0);
    }

    public void draw(int instances) {
        GL31C.glDrawElementsInstanced((int)4, (int)6, (int)5121, (long)0L, (int)instances);
    }

    public void drawWithShader(Matrix4f modelViewMatrix, Matrix4f projectionMatrix, SpaceCoords relativeSpacePos, CelestialShaderInstance shaderInstance, int instances) {
        Vector3f relativeVectorLy = new Vector3f((float)relativeSpacePos.x().ly(), (float)relativeSpacePos.y().ly(), (float)relativeSpacePos.z().ly());
        Vector3f relativeVectorKm = new Vector3f((float)relativeSpacePos.x().km(), (float)relativeSpacePos.y().km(), (float)relativeSpacePos.z().km());
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this._drawWithShader(new Matrix4f((Matrix4fc)modelViewMatrix), new Matrix4f((Matrix4fc)projectionMatrix), relativeVectorLy, relativeVectorKm, shaderInstance, instances));
        } else {
            this._drawWithShader(modelViewMatrix, projectionMatrix, relativeVectorLy, relativeVectorKm, shaderInstance, instances);
        }
    }

    private void _drawWithShader(Matrix4f modelViewMatrix, Matrix4f projectionMatrix, Vector3f relativeSpaceLy, Vector3f relativeSpaceKm, CelestialShaderInstance shaderInstance, int instances) {
        for (int i = 0; i < 12; ++i) {
            int j = RenderSystem.getShaderTexture((int)i);
            shaderInstance.method_34583("Sampler" + i, j);
        }
        if (shaderInstance.field_29470 != null) {
            shaderInstance.field_29470.method_1250(modelViewMatrix);
        }
        if (shaderInstance.field_29471 != null) {
            shaderInstance.field_29471.method_1250(projectionMatrix);
        }
        if (shaderInstance.field_29474 != null) {
            shaderInstance.field_29474.method_1253(RenderSystem.getShaderColor());
        }
        if (shaderInstance.RELATIVE_SPACE_LY != null) {
            shaderInstance.RELATIVE_SPACE_LY.method_34413(relativeSpaceLy);
        }
        if (shaderInstance.RELATIVE_SPACE_KM != null) {
            shaderInstance.RELATIVE_SPACE_KM.method_34413(relativeSpaceKm);
        }
        if (shaderInstance.LENSING_MAT != null) {
            shaderInstance.LENSING_MAT.method_39978(SpaceRenderer.lensingMatrix);
        }
        if (shaderInstance.LENSING_MAT_INV != null) {
            shaderInstance.LENSING_MAT_INV.method_39978(SpaceRenderer.lensingMatrixInv);
        }
        if (shaderInstance.LENSING_INTENSITY != null) {
            shaderInstance.LENSING_INTENSITY.method_1251(SpaceRenderer.lensingIntensity);
        }
        RenderSystem.setupShaderLights((class_5944)shaderInstance);
        shaderInstance.method_34586();
        this.draw(instances);
        shaderInstance.method_34585();
    }

    @Override
    public void close() {
        if (this.instanceBufferId >= 0) {
            RenderSystem.glDeleteBuffers((int)this.instanceBufferId);
            this.instanceBufferId = -1;
        }
        if (this.vertexBufferId >= 0) {
            RenderSystem.glDeleteBuffers((int)this.vertexBufferId);
            this.vertexBufferId = -1;
        }
        if (this.indexBufferId >= 0) {
            RenderSystem.glDeleteBuffers((int)this.indexBufferId);
            this.indexBufferId = -1;
        }
        if (this.arrayObjectId >= 0) {
            RenderSystem.glDeleteVertexArrays((int)this.arrayObjectId);
            this.arrayObjectId = -1;
        }
    }

    public boolean isInvalid() {
        return this.arrayObjectId == -1;
    }
}

