/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.stellarview.StellarView;
import net.povstalec.stellarview.client.resourcepack.ViewCenter;
import org.joml.Matrix4f;

public final class ViewCenters {
    private static Minecraft minecraft = Minecraft.m_91087_();
    private static final HashMap<ResourceLocation, ViewCenter> VIEW_CENTER_MAP = new HashMap();

    public static void clear() {
        VIEW_CENTER_MAP.clear();
    }

    public static void addViewCenter(ResourceLocation location, ViewCenter viewCenter) {
        if (!VIEW_CENTER_MAP.containsKey(location)) {
            VIEW_CENTER_MAP.put(location, viewCenter);
        } else {
            StellarView.LOGGER.error("View Center " + location.toString() + " already exists");
        }
    }

    public static boolean isViewCenterPresent(ResourceLocation location) {
        return VIEW_CENTER_MAP.containsKey(location);
    }

    @Nullable
    public static ViewCenter getViewCenter(ResourceLocation location) {
        return VIEW_CENTER_MAP.get(location);
    }

    public static boolean renderViewCenterSky(ResourceLocation location, ClientLevel level, int ticks, float partialTicks, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        if (!ViewCenters.isViewCenterPresent(location)) {
            return false;
        }
        return ViewCenters.getViewCenter(location).renderSky(level, ticks, partialTicks, poseStack, camera, projectionMatrix, isFoggy, setupFog);
    }

    public static boolean renderViewCenterSky(ClientLevel level, int ticks, float partialTicks, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        return ViewCenters.renderViewCenterSky(level.m_46472_().m_135782_(), level, ticks, partialTicks, poseStack, camera, projectionMatrix, isFoggy, setupFog);
    }
}

