/*
 * Decompiled with CFR 0.152.
 */
package dev.greenhouseteam.rapscallionsandrockhoppers;

import dev.greenhouseteam.rapscallionsandrockhoppers.RapscallionsAndRockhoppers;
import dev.greenhouseteam.rapscallionsandrockhoppers.attachment.BoatLinksAttachment;
import dev.greenhouseteam.rapscallionsandrockhoppers.attachment.PlayerLinksAttachment;
import dev.greenhouseteam.rapscallionsandrockhoppers.entity.Penguin;
import dev.greenhouseteam.rapscallionsandrockhoppers.entity.PenguinType;
import dev.greenhouseteam.rapscallionsandrockhoppers.network.s2c.SyncBoatLinksAttachmentPacket;
import dev.greenhouseteam.rapscallionsandrockhoppers.network.s2c.SyncPlayerLinksAttachmentPacket;
import dev.greenhouseteam.rapscallionsandrockhoppers.platform.services.IRockhoppersPlatformHelper;
import dev.greenhouseteam.rapscallionsandrockhoppers.registry.RockhoppersActivities;
import dev.greenhouseteam.rapscallionsandrockhoppers.registry.RockhoppersAttachments;
import dev.greenhouseteam.rapscallionsandrockhoppers.registry.RockhoppersBlockEntityTypes;
import dev.greenhouseteam.rapscallionsandrockhoppers.registry.RockhoppersBlocks;
import dev.greenhouseteam.rapscallionsandrockhoppers.registry.RockhoppersEntityTypes;
import dev.greenhouseteam.rapscallionsandrockhoppers.registry.RockhoppersItems;
import dev.greenhouseteam.rapscallionsandrockhoppers.registry.RockhoppersMemoryModuleTypes;
import dev.greenhouseteam.rapscallionsandrockhoppers.registry.RockhoppersSensorTypes;
import dev.greenhouseteam.rapscallionsandrockhoppers.registry.RockhoppersSoundEvents;
import dev.greenhouseteam.rapscallionsandrockhoppers.util.RockhoppersResourceKeys;
import java.util.function.Predicate;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.networking.v1.EntityTrackingEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1690;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5483;
import net.minecraft.class_7706;
import org.apache.logging.log4j.util.BiConsumer;

public class RapscallionsAndRockhoppersFabric
implements ModInitializer {
    public void onInitialize() {
        RapscallionsAndRockhoppers.init();
        RockhoppersAttachments.init();
        RapscallionsAndRockhoppersFabric.handleRegistration();
        RapscallionsAndRockhoppersFabric.handleBiomeModifications();
        RapscallionsAndRockhoppersFabric.handlePenguinTypeRegistryEvents();
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            if (player.method_7325() || !(entity instanceof class_1690)) {
                return class_1269.field_5811;
            }
            class_1690 boat = (class_1690)entity;
            return IRockhoppersPlatformHelper.INSTANCE.getBoatData(boat).handleInteractionWithBoatHook(player, hand);
        });
        EntityTrackingEvents.START_TRACKING.register((entity, player) -> {
            Record packet;
            if (entity.hasAttached(RockhoppersAttachments.BOAT_LINKS)) {
                packet = new SyncBoatLinksAttachmentPacket(entity.method_5628(), (BoatLinksAttachment)entity.getAttached(RockhoppersAttachments.BOAT_LINKS));
                ServerPlayNetworking.send((class_3222)player, (class_2960)((SyncBoatLinksAttachmentPacket)packet).comp_1678(), (class_2540)packet.toBuf());
            }
            if (entity.hasAttached(RockhoppersAttachments.PLAYER_LINKS)) {
                packet = new SyncPlayerLinksAttachmentPacket(entity.method_5628(), (PlayerLinksAttachment)entity.getAttached(RockhoppersAttachments.PLAYER_LINKS));
                ServerPlayNetworking.send((class_3222)player, (class_2960)((SyncPlayerLinksAttachmentPacket)packet).comp_1678(), (class_2540)packet.toBuf());
            }
        });
    }

    private static Predicate<BiomeSelectionContext> createPenguinSpawnPredicate() {
        return biomeSelectionContext -> {
            if (RapscallionsAndRockhoppers.getBiomePopulationPenguinTypeRegistry() == null) {
                return false;
            }
            return RapscallionsAndRockhoppers.getBiomePopulationPenguinTypeRegistry().method_10220().anyMatch(penguinType -> penguinType.spawnBiomes().stream().anyMatch(holderSet -> holderSet.holders().method_40241(biomeSelectionContext.getBiomeRegistryEntry())));
        };
    }

    public static void handleBiomeModifications() {
        class_1317.method_20637(RockhoppersEntityTypes.PENGUIN, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, Penguin::checkPenguinSpawnRules);
        RapscallionsAndRockhoppersFabric.createBiomeModifications(RapscallionsAndRockhoppers.asResource("penguin"), RapscallionsAndRockhoppersFabric.createPenguinSpawnPredicate(), RockhoppersEntityTypes.PENGUIN, 15, 3, 5);
    }

    public static void createBiomeModifications(class_2960 location, Predicate<BiomeSelectionContext> predicate, class_1299<?> entityType, int weight, int min, int max) {
        BiomeModifications.create((class_2960)location).add(ModificationPhase.ADDITIONS, predicate, context -> context.getSpawnSettings().addSpawn(class_1311.field_6294, new class_5483.class_1964(entityType, weight, min, max)));
    }

    public static void handleRegistration() {
        DynamicRegistries.registerSynced(RockhoppersResourceKeys.PENGUIN_TYPE_REGISTRY, PenguinType.CODEC, (DynamicRegistries.SyncOption[])new DynamicRegistries.SyncOption[0]);
        RockhoppersBlocks.registerBlocks(class_2378::method_10230);
        RockhoppersItems.registerItems(class_2378::method_10230);
        RockhoppersEntityTypes.registerEntityTypes(class_2378::method_10230);
        RockhoppersSoundEvents.registerSoundEvents(class_2378::method_10230);
        RockhoppersActivities.registerActivities(class_2378::method_10230);
        RockhoppersMemoryModuleTypes.registerMemoryModuleTypes(class_2378::method_10230);
        RockhoppersSensorTypes.registerSensorTypes(class_2378::method_10230);
        RockhoppersBlockEntityTypes.registerBlockEntityTypes(class_2378::method_10230);
        RockhoppersEntityTypes.createMobAttributes(FabricDefaultAttributeRegistry::register);
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41062).register(entries -> RockhoppersItems.addAfterIngredientsTab((BiConsumer<class_1799, class_1799>)((BiConsumer)(x$0, xva$1) -> entries.addAfter(x$0, new class_1799[]{xva$1}))));
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41060).register(entries -> RockhoppersItems.addBeforeToolsAndUtilitiesTab((BiConsumer<class_1799, class_1799>)((BiConsumer)(x$0, xva$1) -> entries.addBefore(x$0, new class_1799[]{xva$1}))));
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40743).register(entries -> RockhoppersItems.addAfterNaturalBlocksTab((BiConsumer<class_1799, class_1799>)((BiConsumer)(x$0, xva$1) -> entries.addAfter(x$0, new class_1799[]{xva$1}))));
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40205).register(entries -> RockhoppersItems.addSpawnEggsTab(arg_0 -> ((FabricItemGroupEntries)entries).method_45420(arg_0)));
    }

    public static void handlePenguinTypeRegistryEvents() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> RapscallionsAndRockhoppers.removeCachedPenguinTypeRegistry(false));
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, closeableResourceManager, success) -> {
            if (success) {
                server.method_3738().forEach(Penguin::invalidateCachedPenguinTypes);
            }
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> RapscallionsAndRockhoppers.removeCachedPenguinTypeRegistry(true));
    }
}

