/*
 * Decompiled with CFR 0.152.
 */
package dev.greenhouseteam.rapscallionsandrockhoppers.attachment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.greenhouseteam.rapscallionsandrockhoppers.RapscallionsAndRockhoppers;
import dev.greenhouseteam.rapscallionsandrockhoppers.attachment.PlayerLinksAttachment;
import dev.greenhouseteam.rapscallionsandrockhoppers.mixin.BoatAccessor;
import dev.greenhouseteam.rapscallionsandrockhoppers.platform.services.IRockhoppersPlatformHelper;
import dev.greenhouseteam.rapscallionsandrockhoppers.registry.RockhoppersItems;
import dev.greenhouseteam.rapscallionsandrockhoppers.util.EntityGetUtil;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1935;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4844;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Unique;

public class BoatLinksAttachment {
    public static final class_2960 ID = RapscallionsAndRockhoppers.asResource("boat_links");
    private static final double HOOK_DAMPENING_FACTOR = 0.2;
    private Set<UUID> penguins;
    private Set<UUID> nextLinkedBoats;
    private Set<UUID> previousLinkedBoats;
    @Nullable
    private UUID linkedPlayer;
    @Nullable
    private class_1690 instance;
    public static final Codec<BoatLinksAttachment> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)class_4844.field_47491.fieldOf("penguins").forGetter(BoatLinksAttachment::getFollowingPenguins), (App)class_4844.field_47491.fieldOf("linked_boats_after").forGetter(BoatLinksAttachment::getNextLinkedBoatUuids), (App)class_4844.field_47491.fieldOf("linked_boats_before").forGetter(BoatLinksAttachment::getPreviousLinkedBoatUuids)).apply((Applicative)inst, BoatLinksAttachment::new));

    public BoatLinksAttachment() {
        this.penguins = new HashSet<UUID>();
        this.nextLinkedBoats = new HashSet<UUID>();
        this.previousLinkedBoats = new HashSet<UUID>();
    }

    public BoatLinksAttachment(Set<UUID> penguins, Set<UUID> nextLinkedBoats, Set<UUID> previousLinkedBoats) {
        this.penguins = penguins;
        this.nextLinkedBoats = nextLinkedBoats;
        this.previousLinkedBoats = previousLinkedBoats;
    }

    public void setFrom(BoatLinksAttachment other) {
        this.penguins = other.penguins;
        this.nextLinkedBoats = other.nextLinkedBoats;
        this.previousLinkedBoats = other.previousLinkedBoats;
    }

    public Set<UUID> getNextLinkedBoatUuids() {
        return this.nextLinkedBoats;
    }

    public Set<UUID> getPreviousLinkedBoatUuids() {
        return this.previousLinkedBoats;
    }

    public void clearNextLinkedBoatUuids() {
        this.nextLinkedBoats.clear();
    }

    public void clearPreviousLinkedBoatUuids() {
        this.previousLinkedBoats.clear();
    }

    @Nullable
    public UUID getLinkedPlayerUuid() {
        return this.linkedPlayer;
    }

    public void setLinkedPlayer(@Nullable UUID player) {
        this.linkedPlayer = player;
    }

    public void addNextLinkedBoat(@Nullable UUID boat) {
        this.nextLinkedBoats.add(boat);
    }

    public void removeNextLinkedBoat(@Nullable UUID boat) {
        this.nextLinkedBoats.remove(boat);
    }

    public void addPreviousLinkedBoat(@Nullable UUID boat) {
        this.previousLinkedBoats.add(boat);
    }

    public void removePreviousLinkedBoat(@Nullable UUID boat) {
        this.previousLinkedBoats.remove(boat);
    }

    public Set<UUID> getFollowingPenguins() {
        return Set.copyOf(this.penguins);
    }

    public int penguinCount() {
        return this.penguins.size();
    }

    public void addFollowingPenguin(UUID penguinUUID) {
        this.penguins.add(penguinUUID);
    }

    public void removeFollowingPenguin(UUID penguinUUID) {
        this.penguins.remove(penguinUUID);
    }

    public void clearFollowingPenguins() {
        this.penguins.clear();
    }

    @Nullable
    public class_1690 getProvider() {
        return this.instance;
    }

    public void setProvider(class_1690 boat) {
        if (this.instance != null) {
            return;
        }
        this.instance = boat;
    }

    public Set<class_1690> getNextLinkedBoats() {
        if (this.getProvider() != null) {
            return this.getNextLinkedBoatUuids().stream().map(uuid -> {
                class_1297 entity = EntityGetUtil.getEntityFromUuid(this.getProvider().method_37908(), uuid);
                if (entity instanceof class_1690) {
                    class_1690 boat = (class_1690)entity;
                    return boat;
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        return Set.of();
    }

    public Set<class_1690> getPreviousLinkedBoats() {
        if (this.getProvider() != null) {
            return this.getPreviousLinkedBoatUuids().stream().map(uuid -> {
                class_1297 entity = EntityGetUtil.getEntityFromUuid(this.getProvider().method_37908(), uuid);
                if (entity instanceof class_1690) {
                    class_1690 boat = (class_1690)entity;
                    return boat;
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        return Set.of();
    }

    @Nullable
    public class_1657 getLinkedPlayer() {
        class_1297 entity;
        if (this.getProvider() != null && (entity = EntityGetUtil.getEntityFromUuid(this.getProvider().method_37908(), this.linkedPlayer)) instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return player;
        }
        return null;
    }

    public boolean canLinkTo(class_1690 otherBoat) {
        BoatLinksAttachment otherBoatData = IRockhoppersPlatformHelper.INSTANCE.getBoatData(otherBoat);
        return !this.getPreviousLinkedBoats().contains(otherBoat) && !this.getNextLinkedBoats().contains(otherBoat) && !otherBoatData.getPreviousLinkedBoats().contains(this.getProvider()) && !otherBoatData.getNextLinkedBoats().contains(this.getProvider());
    }

    public class_1269 handleInteractionWithBoatHook(class_1657 player, class_1268 interactionHand) {
        if (this.getProvider() == null) {
            return class_1269.field_5811;
        }
        PlayerLinksAttachment playerData = IRockhoppersPlatformHelper.INSTANCE.getPlayerData(player);
        if (this.getLinkedPlayer() == player) {
            this.setLinkedPlayer(null);
            playerData.removeLinkedBoat(this.getProvider().method_5667());
            this.sync();
            playerData.sync();
            if (!player.method_31549().field_7477) {
                this.getProvider().method_5706((class_1935)RockhoppersItems.BOAT_HOOK);
            }
            return class_1269.field_5812;
        }
        if (player.method_5998(interactionHand).method_31574(RockhoppersItems.BOAT_HOOK) && (playerData.getLinkedBoats().isEmpty() && this.getPreviousLinkedBoats().isEmpty() && this.getNextLinkedBoats().isEmpty() || player.method_5715())) {
            this.setLinkedPlayer(player.method_5667());
            playerData.addLinkedBoat(this.getProvider().method_5667());
            this.sync();
            playerData.sync();
            if (!player.method_31549().field_7477) {
                player.method_5998(interactionHand).method_7934(1);
            }
            return class_1269.field_5812;
        }
        if (this.getLinkedPlayer() == null && !playerData.getLinkedBoats().isEmpty()) {
            Set<class_1690> otherBoats = playerData.getLinkedBoats();
            for (class_1690 otherBoat : otherBoats) {
                BoatLinksAttachment otherBoatData = IRockhoppersPlatformHelper.INSTANCE.getBoatData(otherBoat);
                if (otherBoat.method_5779((class_1297)this.getProvider()) || !otherBoatData.canLinkTo(this.getProvider()) || otherBoatData.getLinkedPlayer() != player) continue;
                otherBoatData.addPreviousLinkedBoat(this.getProvider().method_5667());
                this.addNextLinkedBoat(otherBoat.method_5667());
                otherBoatData.setLinkedPlayer(null);
                playerData.removeLinkedBoat(otherBoat.method_5667());
                this.sync();
                otherBoatData.sync();
                playerData.sync();
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    public void addBoatMovementCode() {
        if (this.getProvider() == null || this.getProvider().method_37908().method_8608()) {
            return;
        }
        if (this.getLinkedPlayer() != null) {
            float distanceBetween = this.getLinkedPlayer().method_5739((class_1297)this.getProvider());
            if (distanceBetween > 3.0f && distanceBetween < 10.0f) {
                this.rapscallionsandrockhoppers$moveTowardsNonBoat((class_1297)this.getLinkedPlayer());
            }
            if (distanceBetween > 10.0f || !this.getLinkedPlayer().method_5805()) {
                this.getProvider().method_5706((class_1935)RockhoppersItems.BOAT_HOOK);
                this.setLinkedPlayer(null);
            }
        }
        this.moveTowardsBoats(this.getNextLinkedBoatUuids(), this.getPreviousLinkedBoatUuids());
    }

    @Unique
    private void moveTowardsBoats(Set<UUID> nextUuids, Set<UUID> previousUuids) {
        if (!nextUuids.isEmpty()) {
            for (Pair next : nextUuids.stream().map(uuid1 -> {
                class_1297 patt9766$temp = ((class_3218)this.getProvider().method_37908()).method_14190(uuid1);
                if (patt9766$temp instanceof class_1690) {
                    class_1690 boat = (class_1690)patt9766$temp;
                    return Pair.of((Object)uuid1, (Object)boat);
                }
                return Pair.of((Object)uuid1, (Object)null);
            }).toList()) {
                if (next.getSecond() == null || ((class_1690)next.getSecond()).method_31481() || ((class_1690)next.getSecond()).method_5739((class_1297)this.getProvider()) > 16.0f) {
                    if (next.getSecond() != null) {
                        BoatLinksAttachment nextBoatData = IRockhoppersPlatformHelper.INSTANCE.getBoatData((class_1690)next.getSecond());
                        nextBoatData.removePreviousLinkedBoat(this.getProvider().method_5667());
                    }
                    this.getProvider().method_5706((class_1935)RockhoppersItems.BOAT_HOOK);
                    this.removeNextLinkedBoat((UUID)next.getFirst());
                    return;
                }
                this.doBoatLinkedMovementTo((class_1690)next.getSecond());
            }
        }
        if (!previousUuids.isEmpty()) {
            for (Pair previous : previousUuids.stream().map(uuid1 -> {
                class_1297 patt10842$temp = ((class_3218)this.getProvider().method_37908()).method_14190(uuid1);
                if (patt10842$temp instanceof class_1690) {
                    class_1690 boat = (class_1690)patt10842$temp;
                    return Pair.of((Object)uuid1, (Object)boat);
                }
                return Pair.of((Object)uuid1, (Object)null);
            }).toList()) {
                if (previous.getSecond() == null || ((class_1690)previous.getSecond()).method_31481() || ((class_1690)previous.getSecond()).method_5739((class_1297)this.getProvider()) > 16.0f) {
                    if (previous.getSecond() != null) {
                        BoatLinksAttachment nextBoatData = IRockhoppersPlatformHelper.INSTANCE.getBoatData((class_1690)previous.getSecond());
                        nextBoatData.removePreviousLinkedBoat(this.getProvider().method_5667());
                    }
                    this.getProvider().method_5706((class_1935)RockhoppersItems.BOAT_HOOK);
                    this.removePreviousLinkedBoat((UUID)previous.getFirst());
                    return;
                }
                this.doBoatLinkedMovementTo((class_1690)previous.getSecond());
            }
        }
    }

    @Unique
    private void doBoatLinkedMovementTo(class_1690 other) {
        class_243 thisPos = this.getProvider().method_19538();
        class_243 otherPos = other.method_19538();
        float distanceBetween = other.method_5739((class_1297)this.getProvider());
        if (distanceBetween <= 3.0f || distanceBetween > 16.0f) {
            return;
        }
        float distanceFactor = (distanceBetween - 3.0f) / 7.0f;
        class_243 betweenVec = thisPos.method_1035(otherPos).method_1021(0.2);
        class_243 thisDelta = betweenVec.method_1029().method_1021((double)distanceBetween).method_1021((double)distanceFactor);
        thisDelta.method_18805(1.0, 0.0, 1.0);
        thisDelta.method_1031(0.0, this.getProvider().method_18798().method_10214(), 0.0);
        this.getProvider().method_18799(thisDelta);
        if (!(!(this.getProvider().method_18798().method_37267() > 0.05) || this.getProvider().method_42148() && this.getProvider().method_5642() instanceof class_1657)) {
            float cross = (float)otherPos.method_1020(thisPos).method_1036(this.getProvider().method_5663()).method_10214();
            this.getProvider().method_36456(this.getProvider().method_36454() + cross);
        }
    }

    public void rapscallionsandrockhoppers$moveTowardsNonBoat(class_1297 other) {
        class_243 thisPos = this.getProvider().method_19538();
        class_243 otherPos = other.method_19538();
        if (other.method_18798().method_37267() > 0.05) {
            float cross = (float)otherPos.method_1020(thisPos).method_1036(this.getProvider().method_5663()).method_10214();
            this.getProvider().method_36456(this.getProvider().method_36454() + cross);
        }
        if (this.getProvider().method_37908().method_8608()) {
            return;
        }
        double distanceBetween = other.method_19538().method_18805(1.0, 0.0, 1.0).method_1022(this.getProvider().method_19538().method_18805(1.0, 0.0, 1.0));
        if (distanceBetween > 3.0) {
            double distanceFactor = (distanceBetween - 3.0) / 7.0;
            class_243 delta = this.getProvider().method_19538().method_1035(other.method_19538()).method_1029().method_1021(distanceBetween).method_1021(distanceFactor);
            if (((BoatAccessor)this.getProvider()).rapscallionsandrockhoppers$getStatus() != null && ((BoatAccessor)this.getProvider()).rapscallionsandrockhoppers$getStatus().equals((Object)class_1690.class_1691.field_7718) && delta.method_10214() < 0.0) {
                delta = new class_243(delta.method_10216(), this.getProvider().method_18798().method_10214(), delta.method_10215());
            }
            this.getProvider().method_18799(delta);
        }
    }

    public void deserializeLegacyData(class_2487 tag) {
        class_2499 boats;
        this.clearNextLinkedBoatUuids();
        if (tag.method_10573("next_linked_boats", 9)) {
            boats = tag.method_10554("next_linked_boats", 11);
            for (class_2520 boat : boats) {
                this.addNextLinkedBoat(class_2512.method_25930((class_2520)boat));
            }
        }
        this.clearPreviousLinkedBoatUuids();
        if (tag.method_10573("previous_linked_boats", 9)) {
            boats = tag.method_10554("previous_linked_boats", 11);
            for (class_2520 boat : boats) {
                this.addPreviousLinkedBoat(class_2512.method_25930((class_2520)boat));
            }
        }
        this.clearFollowingPenguins();
        if (tag.method_10573("following_penguins", 9)) {
            class_2499 penguins = tag.method_10554("following_penguins", 11);
            for (class_2520 penguin : penguins) {
                this.addFollowingPenguin(class_2512.method_25930((class_2520)penguin));
            }
        }
    }

    public void sync() {
        if (this.getProvider() == null || this.getProvider().method_37908().method_8608()) {
            return;
        }
        IRockhoppersPlatformHelper.INSTANCE.syncBoatData(this.getProvider());
    }
}

