/*
 * Decompiled with CFR 0.152.
 */
package dev.greenhouseteam.rapscallionsandrockhoppers.attachment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.greenhouseteam.rapscallionsandrockhoppers.RapscallionsAndRockhoppers;
import dev.greenhouseteam.rapscallionsandrockhoppers.platform.services.IRockhoppersPlatformHelper;
import dev.greenhouseteam.rapscallionsandrockhoppers.util.EntityGetUtil;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_4844;
import org.jetbrains.annotations.Nullable;

public class PlayerLinksAttachment {
    public static final class_2960 ID = RapscallionsAndRockhoppers.asResource("boat_hook_player");
    private Set<UUID> linkedBoats;
    @Nullable
    private class_1657 instance;
    public static final Codec<PlayerLinksAttachment> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)class_4844.field_47491.fieldOf("linked_boats").forGetter(PlayerLinksAttachment::getLinkedBoatUUIDs)).apply((Applicative)inst, PlayerLinksAttachment::new));

    public PlayerLinksAttachment() {
        this.linkedBoats = new HashSet<UUID>();
    }

    public void setFrom(PlayerLinksAttachment other) {
        this.linkedBoats = other.linkedBoats;
    }

    public PlayerLinksAttachment(Set<UUID> linkedBoats) {
        this.linkedBoats = linkedBoats;
    }

    public Set<UUID> getLinkedBoatUUIDs() {
        return this.linkedBoats;
    }

    public void addLinkedBoat(UUID boat) {
        this.linkedBoats.add(boat);
    }

    public void removeLinkedBoat(UUID boat) {
        this.linkedBoats.remove(boat);
    }

    public void clearLinkedBoats() {
        this.linkedBoats.clear();
    }

    @Nullable
    public class_1657 getProvider() {
        return this.instance;
    }

    public void setProvider(class_1657 player) {
        this.instance = player;
    }

    public Set<class_1690> getLinkedBoats() {
        if (this.getProvider() == null) {
            return Set.of();
        }
        return this.getLinkedBoatUUIDs().stream().map(uuid -> {
            class_1297 entity = EntityGetUtil.getEntityFromUuid(this.getProvider().method_37908(), uuid);
            if (entity instanceof class_1690) {
                class_1690 boat = (class_1690)entity;
                return boat;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public void invalidateNonExistentBoats() {
        this.getLinkedBoatUUIDs().removeIf(uuid -> this.getLinkedBoats().stream().noneMatch(boat -> boat.method_5667() == uuid && !boat.method_31481()));
    }

    public void deserializeLegacyData(class_2487 tag) {
        this.clearLinkedBoats();
        if (tag.method_10573("linked_boat", 9)) {
            class_2499 linkedBoats = tag.method_10554("linked_boat", 11);
            for (class_2520 linkedBoat : linkedBoats) {
                this.addLinkedBoat(class_2512.method_25930((class_2520)linkedBoat));
            }
        }
    }

    public void sync() {
        if (this.getProvider() == null || this.getProvider().method_37908().method_8608()) {
            return;
        }
        IRockhoppersPlatformHelper.INSTANCE.syncPlayerData(this.getProvider());
    }
}

