/*
 * Decompiled with CFR 0.152.
 */
package dev.greenhouseteam.rapscallionsandrockhoppers.entity.behaviour;

import com.mojang.datafixers.util.Pair;
import dev.greenhouseteam.rapscallionsandrockhoppers.entity.Penguin;
import dev.greenhouseteam.rapscallionsandrockhoppers.registry.RockhoppersMemoryModuleTypes;
import dev.greenhouseteam.rapscallionsandrockhoppers.registry.RockhoppersTags;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1536;
import net.minecraft.class_1542;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3902;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_5819;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class JumpTowardsCatch
extends ExtendedBehaviour<Penguin> {
    private boolean breached;

    protected boolean checkExtraStartConditions(class_3218 level, Penguin penguin) {
        return penguin.getTimeAllowedToEat() < penguin.field_6012;
    }

    public boolean shouldKeepRunning(Penguin penguin) {
        double yMovement = penguin.method_18798().method_10214();
        return !(yMovement * yMovement < (double)0.03f && penguin.method_36455() != 0.0f && Math.abs(penguin.method_36455()) < 30.0f && penguin.method_5799() || penguin.method_24828());
    }

    protected void start(Penguin penguin) {
        BrainUtils.setMemory((class_1309)penguin, RockhoppersMemoryModuleTypes.IS_JUMPING, (Object)class_3902.field_17274);
        class_1536 hook = (class_1536)BrainUtils.getMemory((class_1309)penguin, RockhoppersMemoryModuleTypes.CAUGHT_BOBBER);
        class_243 movementVec = hook.method_19538().method_1020(penguin.method_19538()).method_1029();
        penguin.method_18799(penguin.method_18798().method_1031(movementVec.method_10216() * 0.8, 0.4, movementVec.method_10215() * 0.8));
    }

    protected void stop(Penguin penguin) {
        this.breached = false;
        penguin.method_36457(0.0f);
        penguin.setTimeAllowedToWaterJump(Optional.of(penguin.field_6012 + class_3532.method_32751((class_5819)penguin.method_6051(), (int)400, (int)600)));
        BrainUtils.clearMemories((class_1309)penguin, (class_4140[])new class_4140[]{RockhoppersMemoryModuleTypes.IS_JUMPING, RockhoppersMemoryModuleTypes.CAUGHT_BOBBER});
    }

    public void tick(Penguin penguin) {
        boolean breached = this.breached;
        if (!breached) {
            class_3610 fluidState = penguin.method_37908().method_8316(penguin.method_24515());
            this.breached = fluidState.method_15767(class_3486.field_15517);
        }
        if (this.breached && !breached) {
            penguin.method_5783(penguin.getWaterJumpSound(), 1.0f, 1.0f);
        }
        if (penguin.getTimeAllowedToEat() < penguin.field_6012) {
            Optional<class_1542> item = penguin.method_37908().method_8390(class_1542.class, penguin.method_5829().method_1014(1.25), itemEntity -> itemEntity.method_6983().method_31573(RockhoppersTags.ItemTags.PENGUIN_FOOD_ITEMS)).stream().min(Comparator.comparing(arg_0 -> ((Penguin)penguin).method_5739(arg_0)));
            if (item.isPresent()) {
                penguin.setHungryTime(Optional.of(penguin.field_6012 + 4800));
                penguin.setTimeAllowedToEat(Optional.of(penguin.field_6012 + 400));
                if (penguin.getBoatToFollow() != null) {
                    penguin.incrementFishEaten();
                }
                item.get().method_31472();
            }
        }
        class_243 movement = penguin.method_18798();
        if (movement.field_1351 * movement.field_1351 < (double)0.03f && penguin.method_36455() != 0.0f) {
            penguin.method_36457(class_3532.method_17821((float)0.2f, (float)penguin.method_36455(), (float)0.0f));
        } else if (movement.method_1033() > (double)1.0E-5f) {
            double horizontalDistance = movement.method_37267();
            double atan2 = Math.atan2(-movement.field_1351, horizontalDistance) * 180.0 / 1.5707963705062866;
            penguin.method_36457((float)atan2);
        }
    }

    protected List<Pair<class_4140<?>, class_4141>> getMemoryRequirements() {
        return List.of(Pair.of((Object)class_4140.field_37442, (Object)class_4141.field_18456), Pair.of(RockhoppersMemoryModuleTypes.CAUGHT_BOBBER, (Object)class_4141.field_18456));
    }
}

