/*
 * Decompiled with CFR 0.152.
 */
package dev.greenhouseteam.rapscallionsandrockhoppers.entity.behaviour;

import com.mojang.datafixers.util.Pair;
import dev.greenhouseteam.rapscallionsandrockhoppers.entity.Penguin;
import dev.greenhouseteam.rapscallionsandrockhoppers.registry.RockhoppersMemoryModuleTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3902;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_5819;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class PenguinJump
extends ExtendedBehaviour<Penguin> {
    private static final int[] STEPS_TO_CHECK = new int[]{0, 1, 4, 5, 6, 7, 8};
    private boolean breached;

    protected boolean checkExtraStartConditions(class_3218 level, Penguin penguin) {
        if (penguin.getTimeAllowedToWaterJump() > penguin.field_6012 || penguin.method_5669() > 260) {
            return false;
        }
        class_2350 direction = penguin.method_5755();
        int x = direction.method_10148();
        int z = direction.method_10165();
        class_2338 blockPos = penguin.method_24515();
        for (int step : STEPS_TO_CHECK) {
            if (this.waterIsClear(level, blockPos, x, z, step) && this.surfaceIsClear(level, blockPos, x, z, step)) continue;
            return false;
        }
        return true;
    }

    private boolean waterIsClear(class_3218 level, class_2338 pos, int x, int z, int step) {
        class_2338 blockPos = pos.method_10069(x * step, 0, z * step);
        return level.method_8316(blockPos).method_15767(class_3486.field_15517) && !level.method_8320(blockPos).method_51366();
    }

    private boolean surfaceIsClear(class_3218 level, class_2338 pos, int x, int z, int step) {
        class_2338 blockPos = pos.method_10069(x * step, 1, z * step);
        return level.method_8320(blockPos).method_26215() && level.method_8320(blockPos).method_26215();
    }

    public boolean shouldKeepRunning(Penguin penguin) {
        double yMovement = penguin.method_18798().method_10214();
        return !(yMovement * yMovement < (double)0.03f && penguin.method_36455() != 0.0f && Math.abs(penguin.method_36455()) < 30.0f && penguin.method_5799() || penguin.method_24828());
    }

    protected void start(Penguin penguin) {
        BrainUtils.setMemory((class_1309)penguin, RockhoppersMemoryModuleTypes.IS_JUMPING, (Object)class_3902.field_17274);
        class_2350 direction = penguin.method_5755();
        penguin.method_18799(penguin.method_18798().method_1031((double)direction.method_10148() * 0.6, 0.4, (double)direction.method_10165() * 0.6));
    }

    protected void stop(Penguin penguin) {
        this.breached = false;
        penguin.method_36457(0.0f);
        penguin.setTimeAllowedToWaterJump(Optional.of(penguin.field_6012 + class_3532.method_32751((class_5819)penguin.method_6051(), (int)400, (int)600)));
        BrainUtils.clearMemories((class_1309)penguin, (class_4140[])new class_4140[]{RockhoppersMemoryModuleTypes.IS_JUMPING});
    }

    public void tick(Penguin penguin) {
        boolean breached = this.breached;
        if (!breached) {
            class_3610 fluidState = penguin.method_37908().method_8316(penguin.method_24515());
            this.breached = fluidState.method_15767(class_3486.field_15517);
        }
        if (this.breached && !breached) {
            penguin.method_5783(penguin.getWaterJumpSound(), 1.0f, 1.0f);
        }
        class_243 movement = penguin.method_18798();
        if (movement.field_1351 < 0.0 && penguin.method_36455() != 0.0f) {
            penguin.method_36457(class_3532.method_17821((float)0.2f, (float)penguin.method_36455(), (float)0.0f));
        } else if (movement.method_1033() > (double)1.0E-5f) {
            double horizontalDistance = movement.method_37267();
            double atan2 = Math.atan2(-movement.field_1351, horizontalDistance) * 180.0 / 3.1415927410125732;
            penguin.method_36457((float)atan2);
        }
    }

    protected List<Pair<class_4140<?>, class_4141>> getMemoryRequirements() {
        return List.of(Pair.of((Object)class_4140.field_37442, (Object)class_4141.field_18456));
    }
}

