/*
 * Decompiled with CFR 0.152.
 */
package dev.greenhouseteam.rapscallionsandrockhoppers.platform;

import com.google.auto.service.AutoService;
import dev.greenhouseteam.rapscallionsandrockhoppers.attachment.BoatLinksAttachment;
import dev.greenhouseteam.rapscallionsandrockhoppers.attachment.PlayerLinksAttachment;
import dev.greenhouseteam.rapscallionsandrockhoppers.network.RockhoppersPackets;
import dev.greenhouseteam.rapscallionsandrockhoppers.network.s2c.RapscallionsAndRockhoppersPacketS2C;
import dev.greenhouseteam.rapscallionsandrockhoppers.network.s2c.SyncBoatLinksAttachmentPacket;
import dev.greenhouseteam.rapscallionsandrockhoppers.network.s2c.SyncPlayerLinksAttachmentPacket;
import dev.greenhouseteam.rapscallionsandrockhoppers.platform.services.IRockhoppersPlatformHelper;
import dev.greenhouseteam.rapscallionsandrockhoppers.registry.RockhoppersAttachments;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_2487;

@AutoService(value={IRockhoppersPlatformHelper.class})
public class FabricRockhoppersPlatformHelper
implements IRockhoppersPlatformHelper {
    @Override
    public String getPlatformName() {
        return "Fabric";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public void sendS2CTracking(RapscallionsAndRockhoppersPacketS2C packet, class_1297 entity) {
        RockhoppersPackets.sendS2CTracking(packet, entity);
    }

    @Override
    public BoatLinksAttachment getBoatData(class_1690 boat) {
        BoatLinksAttachment attachment = (BoatLinksAttachment)boat.getAttachedOrCreate(RockhoppersAttachments.BOAT_LINKS);
        if (attachment.getProvider() == null) {
            attachment.setProvider(boat);
        }
        return attachment;
    }

    @Override
    public void syncBoatData(class_1690 boat) {
        this.sendS2CTracking(new SyncBoatLinksAttachmentPacket(boat.method_5628(), this.getBoatData(boat)), (class_1297)boat);
    }

    @Override
    public PlayerLinksAttachment getPlayerData(class_1657 player) {
        PlayerLinksAttachment attachment = (PlayerLinksAttachment)player.getAttachedOrCreate(RockhoppersAttachments.PLAYER_LINKS);
        if (attachment.getProvider() == null) {
            attachment.setProvider(player);
        }
        return attachment;
    }

    @Override
    public void syncPlayerData(class_1657 player) {
        this.sendS2CTracking(new SyncPlayerLinksAttachmentPacket(player.method_5628(), this.getPlayerData(player)), (class_1297)player);
    }

    @Override
    public boolean runAndIsBreedEventCancelled(class_1429 parent, class_1429 otherParent) {
        return false;
    }

    @Override
    public class_2487 getLegacyTagStart(class_2487 entityTag) {
        return entityTag.method_10562("cardinal_components");
    }
}

