/*
 * Decompiled with CFR 0.152.
 */
package mod.torchbowmod;

import javax.annotation.Nullable;
import mod.torchbowmod.TorchBowMod;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class EntityTorch
extends AbstractArrow {
    public EntityTorch(EntityType<EntityTorch> entityTorchEntityType, Level level) {
        super(entityTorchEntityType, level);
    }

    public EntityTorch(Level worldIn, LivingEntity shooter, ItemStack pickup, @Nullable ItemStack weaponStack) {
        super((EntityType)TorchBowMod.entityTorch.get(), shooter, worldIn, pickup, weaponStack);
    }

    protected void onHitEntity(@NotNull EntityHitResult entityRayTraceResult) {
        super.onHitEntity(entityRayTraceResult);
        Entity entity = entityRayTraceResult.getEntity();
        if (entity instanceof Creeper) {
            Creeper creeper = (Creeper)entity;
            this.creeperIgnite(creeper);
        }
        entity.setRemainingFireTicks(100);
    }

    protected void onHitBlock(@NotNull BlockHitResult raytraceResultIn) {
        super.onHitBlock(raytraceResultIn);
        HitResult.Type raytraceresult$type = raytraceResultIn.getType();
        if (raytraceresult$type == HitResult.Type.BLOCK) {
            BlockPos statePos = raytraceResultIn.getBlockPos();
            if (this.level().getBlockState(statePos).getBlock() == Blocks.TNT) {
                this.tntIgnite(raytraceResultIn);
            } else {
                this.setTorch(raytraceResultIn, (HitResult)raytraceResultIn);
            }
        }
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Blocks.TORCH);
    }

    private void creeperIgnite(Creeper creeper) {
        if (Math.random() < 0.05) {
            creeper.ignite();
            LightningBolt bolt = new LightningBolt(EntityType.LIGHTNING_BOLT, this.level());
            bolt.setPos(creeper.getOnPos().getCenter());
            this.level().addFreshEntity((Entity)bolt);
        } else if (Math.random() < 0.3) {
            creeper.ignite();
        }
    }

    private void tntIgnite(BlockHitResult blockHitResult) {
        Level world = this.level();
        BlockPos blockPos = blockHitResult.getBlockPos();
        BlockState blockState = world.getBlockState(blockPos);
        Block block = blockState.getBlock();
        block.onCaughtFire(blockState, world, blockPos, null, null);
        world.removeBlock(blockPos, false);
        this.remove(Entity.RemovalReason.KILLED);
    }

    private void setTorch(BlockHitResult blockraytraceresult, HitResult raytraceResultIn) {
        BlockPos blockpos = blockraytraceresult.getBlockPos();
        if (!this.level().getBlockState(blockpos).isAir() && !this.level().isClientSide) {
            Direction face = ((BlockHitResult)raytraceResultIn).getDirection();
            BlockState torch_state = Blocks.WALL_TORCH.defaultBlockState();
            BlockPos setBlockPos = this.getPosOfFace(blockpos, face);
            if (this.isBlockAIR(setBlockPos)) {
                if (face == Direction.UP) {
                    torch_state = Blocks.TORCH.defaultBlockState();
                    this.level().setBlock(setBlockPos, torch_state, 3);
                    this.remove(Entity.RemovalReason.KILLED);
                } else if (face == Direction.DOWN && TorchBowMod.CeilingTorch != Blocks.AIR) {
                    BlockState ceiling_torch = TorchBowMod.CeilingTorch.defaultBlockState();
                    this.level().setBlock(setBlockPos, ceiling_torch, 3);
                    this.remove(Entity.RemovalReason.KILLED);
                } else if (face != Direction.DOWN) {
                    this.level().setBlock(setBlockPos, (BlockState)torch_state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)face), 3);
                    this.remove(Entity.RemovalReason.KILLED);
                }
            }
        }
    }

    private BlockPos getPosOfFace(BlockPos blockPos, Direction face) {
        return switch (face) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> blockPos.above();
            case Direction.EAST -> blockPos.east();
            case Direction.WEST -> blockPos.west();
            case Direction.SOUTH -> blockPos.south();
            case Direction.NORTH -> blockPos.north();
            case Direction.DOWN -> blockPos.below();
        };
    }

    private boolean isBlockAIR(BlockPos pos) {
        Block[] a;
        Block getBlock = this.level().getBlockState(pos).getBlock();
        if (getBlock instanceof BushBlock) {
            return true;
        }
        for (Block traget : a = new Block[]{Blocks.CAVE_AIR, Blocks.AIR, Blocks.SNOW, Blocks.VINE}) {
            if (getBlock != traget) continue;
            return true;
        }
        return false;
    }
}

