/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib;

import com.finderfeed.fdlib.FDClientHelpers;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimatedObject;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationSystem;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationTicker;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.TickerSyncInstance;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.model_system.ModelSystem;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.model_system.attachments.ModelAttachmentData;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class FDClientPacketExecutables {
    public static void testCameraPacket() {
    }

    public static void addEntityAttachmentPacket(int entityId, int layer, String bone, UUID uuid, ModelAttachmentData<?> modelInfo) {
        Entity entity = FDClientHelpers.getClientLevel().getEntity(entityId);
        if (entity instanceof AnimatedObject) {
            AnimatedObject animatedObject = (AnimatedObject)entity;
            animatedObject.getModelSystem().attachToLayer(layer, bone, uuid, modelInfo);
        }
    }

    public static void removeEntityAttachment(int entityId, UUID uuid) {
        Entity entity = FDClientHelpers.getClientLevel().getEntity(entityId);
        if (entity instanceof AnimatedObject) {
            AnimatedObject animatedObject = (AnimatedObject)entity;
            animatedObject.getModelSystem().removeAttachment(uuid);
        }
    }

    public static void syncEntityAttachmentsPacket(int entityId, CompoundTag data) {
        Entity entity = FDClientHelpers.getClientLevel().getEntity(entityId);
        if (entity instanceof AnimatedObject) {
            AnimatedObject animatedObject = (AnimatedObject)entity;
            ModelSystem modelSystem = animatedObject.getModelSystem();
            modelSystem.loadAttachments((HolderLookup.Provider)FDClientHelpers.getClientLevel().registryAccess(), data);
        }
    }

    public static void movePlayer(Vec3 movement) {
        LocalPlayer player = Minecraft.getInstance().player;
        player.setDeltaMovement(movement);
    }

    public static void playsoundInEars(SoundEvent event, float pitch, float volume) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)event, (float)pitch, (float)volume));
    }

    public static void entityStartAnimationPacket(int entityId, String tickerName, AnimationTicker ticker) {
        Entity entity = Minecraft.getInstance().level.getEntity(entityId);
        if (entity instanceof AnimatedObject) {
            AnimatedObject object = (AnimatedObject)entity;
            AnimationSystem system = object.getAnimationSystem();
            system.startAnimation(tickerName, ticker);
        }
    }

    public static void entityStopAnimationPacket(int entityId, String tickerName) {
        Entity entity = Minecraft.getInstance().level.getEntity(entityId);
        if (entity instanceof AnimatedObject) {
            AnimatedObject object = (AnimatedObject)entity;
            AnimationSystem system = object.getAnimationSystem();
            system.stopAnimation(tickerName);
        }
    }

    public static void entitySyncAnimationsPacket(int entityId, List<TickerSyncInstance> syncInstances) {
        Entity entity = Minecraft.getInstance().level.getEntity(entityId);
        if (entity instanceof AnimatedObject) {
            AnimatedObject object = (AnimatedObject)entity;
            AnimationSystem system = object.getAnimationSystem();
            HashMap<String, AnimationTicker> map = system.getTickers();
            map.clear();
            for (TickerSyncInstance inst : syncInstances) {
                map.put(inst.tickerName(), inst.ticker());
            }
        }
    }

    public static void tileEntityFreezeAnimations(BlockPos pos, boolean state) {
        ClientLevel level = Minecraft.getInstance().level;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof AnimatedObject)) {
            return;
        }
        AnimatedObject object = (AnimatedObject)blockEntity;
        object.getAnimationSystem().setFrozen(state);
    }

    public static void tileEntityStartAnimation(BlockPos pos, AnimationTicker ticker, String layer) {
        ClientLevel level = Minecraft.getInstance().level;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof AnimatedObject)) {
            return;
        }
        AnimatedObject object = (AnimatedObject)blockEntity;
        object.getAnimationSystem().startAnimation(layer, ticker);
    }

    public static void tileEntityStopAnimation(BlockPos pos, String layer) {
        ClientLevel level = Minecraft.getInstance().level;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof AnimatedObject)) {
            return;
        }
        AnimatedObject object = (AnimatedObject)blockEntity;
        object.getAnimationSystem().stopAnimation(layer);
    }

    public static void tileEntitySyncAnimations(BlockPos pos, List<TickerSyncInstance> syncInstances) {
        ClientLevel level = Minecraft.getInstance().level;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof AnimatedObject)) {
            return;
        }
        AnimatedObject object = (AnimatedObject)blockEntity;
        AnimationSystem system = object.getAnimationSystem();
        HashMap<String, AnimationTicker> map = system.getTickers();
        map.clear();
        for (TickerSyncInstance inst : syncInstances) {
            map.put(inst.tickerName(), inst.ticker());
        }
    }

    public static void entityFreezeAnimations(int entityId, boolean state) {
        Entity entity = Minecraft.getInstance().level.getEntity(entityId);
        if (entity instanceof AnimatedObject) {
            AnimatedObject object = (AnimatedObject)entity;
            AnimationSystem system = object.getAnimationSystem();
            system.setFrozen(state);
        }
    }
}

