/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib;

import com.finderfeed.fdlib.network.lib_packets.PlayerMovePacket;
import com.finderfeed.fdlib.systems.cutscenes.CutsceneData;
import com.finderfeed.fdlib.systems.cutscenes.packets.MoveCutsceneCameraPacket;
import com.finderfeed.fdlib.systems.cutscenes.packets.StartCutscenePacket;
import com.finderfeed.fdlib.systems.cutscenes.packets.StopCutscenePacket;
import com.finderfeed.fdlib.systems.impact_frames.ImpactFrame;
import com.finderfeed.fdlib.systems.impact_frames.ImpactFramesPacket;
import com.finderfeed.fdlib.systems.particle.particle_emitter.ParticleEmitterData;
import com.finderfeed.fdlib.systems.particle.particle_emitter.ParticleEmitterHandler;
import com.finderfeed.fdlib.systems.particle.particle_emitter.ParticleEmitterPacket;
import com.finderfeed.fdlib.systems.screen.screen_effect.ScreenEffect;
import com.finderfeed.fdlib.systems.screen.screen_effect.ScreenEffectData;
import com.finderfeed.fdlib.systems.screen.screen_effect.ScreenEffectType;
import com.finderfeed.fdlib.systems.screen.screen_effect.SendScreenEffectPacket;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class FDLibCalls {
    public static final TargetingConditions ALL = TargetingConditions.forNonCombat().selector(p -> true).ignoreLineOfSight().ignoreInvisibilityTesting();

    public static void startCutsceneForPlayer(ServerPlayer player, CutsceneData data) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new StartCutscenePacket(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void startCutsceneForPlayers(ServerLevel level, Vec3 pos, double radius, CutsceneData data) {
        PacketDistributor.sendToPlayersNear((ServerLevel)level, null, (double)pos.x, (double)pos.y, (double)pos.z, (double)radius, (CustomPacketPayload)new StartCutscenePacket(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void moveCutsceneCameraForPlayer(ServerPlayer player, CutsceneData data) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new MoveCutsceneCameraPacket(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void moveCutsceneCameraForPlayers(ServerLevel level, Vec3 pos, double radius, CutsceneData data) {
        PacketDistributor.sendToPlayersNear((ServerLevel)level, null, (double)pos.x, (double)pos.y, (double)pos.z, (double)radius, (CustomPacketPayload)new MoveCutsceneCameraPacket(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void stopCutsceneForPlayer(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new StopCutscenePacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void stopCutsceneForPlayers(ServerLevel level, Vec3 pos, double radius) {
        PacketDistributor.sendToPlayersNear((ServerLevel)level, null, (double)pos.x, (double)pos.y, (double)pos.z, (double)radius, (CustomPacketPayload)new StopCutscenePacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static <T> T getListValueSafe(int id, List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        if (id < 0 || id >= list.size()) {
            return null;
        }
        return list.get(id);
    }

    public static <T> T getListValueOrBoundaries(int id, List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        if (id < 0) {
            return list.getFirst();
        }
        if (id >= list.size()) {
            return list.getLast();
        }
        return list.get(id);
    }

    public static void addParticleEmitter(Level level, double sendRadius, ParticleEmitterData data) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel, null, (double)data.position.x, (double)data.position.y, (double)data.position.z, (double)sendRadius, (CustomPacketPayload)new ParticleEmitterPacket(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            ParticleEmitterHandler.addParticleEmitter(data);
        }
    }

    public static void addParticleEmitter(ServerPlayer player, ParticleEmitterData data) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ParticleEmitterPacket(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendImpactFrames(ServerLevel level, Vec3 point, float sendRadius, ImpactFrame ... frames) {
        PacketDistributor.sendToPlayersNear((ServerLevel)level, null, (double)point.x, (double)point.y, (double)point.z, (double)sendRadius, (CustomPacketPayload)new ImpactFramesPacket(Arrays.stream(frames).toList()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void setServerPlayerSpeed(ServerPlayer player, Vec3 deltaMovement) {
        player.setDeltaMovement(deltaMovement);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PlayerMovePacket(deltaMovement), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendParticles(ServerLevel level, ParticleOptions options, Vec3 pos, double radius) {
        for (Player player : level.getNearbyPlayers(ALL, null, new AABB(pos.add(-radius, -radius, -radius), pos.add(radius, radius, radius)))) {
            level.sendParticles((ServerPlayer)player, options, true, pos.x, pos.y, pos.z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void sendParticles(ServerLevel level, ParticleOptions options, Vec3 pos, double radius, int amount, double xd, double yd, double zd, double speed) {
        for (Player player : level.getNearbyPlayers(ALL, null, new AABB(pos.add(-radius, -radius, -radius), pos.add(radius, radius, radius)))) {
            level.sendParticles((ServerPlayer)player, options, true, pos.x, pos.y, pos.z, amount, xd, yd, zd, speed);
        }
    }

    public static <D extends ScreenEffectData, T extends ScreenEffect<D>> void sendScreenEffect(ServerPlayer player, ScreenEffectType<D, T> type, D data, int inTime, int stayTime, int outTime) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, new SendScreenEffectPacket<D, T>(data, type, inTime, stayTime, outTime), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static <D extends ScreenEffectData, T extends ScreenEffect<D>> void sendScreenEffect(ServerPlayer player, Supplier<ScreenEffectType<D, T>> type, D data, int inTime, int stayTime, int outTime) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, new SendScreenEffectPacket<D, T>(data, type.get(), inTime, stayTime, outTime), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

