/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.screen;

import com.finderfeed.fdlib.systems.screen.Anchor;
import com.finderfeed.fdlib.systems.screen.FDScreenComponent;
import com.finderfeed.fdlib.systems.screen.default_components.EmptyComponent;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

@Deprecated
public abstract class FDScreen
extends Screen {
    private HashMap<String, FDScreenComponent> componentLookup = new HashMap();
    private List<FDScreenComponent> screenLayers = new ArrayList<FDScreenComponent>();
    private FDScreenComponent focused = null;
    private FDScreenComponent hovered = null;
    protected float mx;
    protected float my;

    public FDScreen() {
        super((Component)Component.empty());
    }

    protected void init() {
        super.init();
        this.componentLookup.clear();
        this.screenLayers.clear();
        Window window = Minecraft.getInstance().getWindow();
        EmptyComponent component = new EmptyComponent(this, "main", 0.0f, 0.0f, window.getGuiScaledWidth(), window.getGuiScaledHeight());
        this.screenLayers.add(component);
        this.componentLookup.put("main", component);
    }

    public void tick() {
        super.tick();
        boolean wasHovered = false;
        for (FDScreenComponent component : this.screenLayers) {
            component.tick();
            if (wasHovered) continue;
            wasHovered = this.decideHoveredComponent(component, this.mx, this.my);
        }
    }

    private boolean decideHoveredComponent(FDScreenComponent component, float mx, float my) {
        if (component.isMouseOver(mx, my)) {
            List<FDScreenComponent> children = component.getChildren().getChildren();
            for (int i = children.size() - 1; i >= 0; --i) {
                float chy;
                float cmy;
                FDScreenComponent child = children.get(i);
                Anchor anchor = child.getAnchor();
                float chx = anchor.xTransform.apply(component, Float.valueOf(child.getX())).floatValue();
                float cmx = mx - chx;
                if (!this.decideHoveredComponent(child, cmx, cmy = my - (chy = anchor.yTransform.apply(component, Float.valueOf(child.getY())).floatValue()))) continue;
                return true;
            }
            if (this.hovered != component) {
                if (this.hovered != null) {
                    this.hovered.setHovered(false);
                }
                component.setHovered(true);
                this.hovered = component;
            }
            return true;
        }
        return false;
    }

    public void render(GuiGraphics graphics, int mx, int my, float partialTicks) {
        this.mx = mx;
        this.my = my;
        for (FDScreenComponent component : this.screenLayers) {
            this.renderComponent(component, graphics, 0.0f, 0.0f, mx, my, partialTicks);
        }
    }

    public void renderComponent(FDScreenComponent component, GuiGraphics graphics, float x, float y, float mx, float my, float partialTicks) {
        component.renderComponent(graphics, x, y, mx, my, partialTicks);
        PoseStack matrices = graphics.pose();
        matrices.pushPose();
        matrices.translate(0.0f, 0.0f, 10.0f);
        for (FDScreenComponent child : component.getChildren()) {
            float cx = x + child.getX();
            float cy = y + child.getY();
            float cmx = mx - child.getX();
            float cmy = my - child.getY();
            Anchor anchor = child.getAnchor();
            cx = anchor.xTransform.apply(component, Float.valueOf(cx)).floatValue();
            cy = anchor.yTransform.apply(component, Float.valueOf(cy)).floatValue();
            this.renderComponent(child, graphics, cx, cy, cmx, cmy, partialTicks);
        }
        matrices.popPose();
        component.postRenderComponent(graphics, x, y, mx, my, partialTicks);
    }

    public boolean mouseClicked(double mx, double my, int button) {
        for (FDScreenComponent component : this.screenLayers) {
            if (!this.clickRecursively(component, (float)mx, (float)my, button)) continue;
            return true;
        }
        if (this.focused != null) {
            this.focused.setFocused(false);
            this.focused = null;
        }
        return false;
    }

    protected boolean clickRecursively(FDScreenComponent component, float mx, float my, int button) {
        if (component.isMouseOver(mx, my)) {
            for (FDScreenComponent child : component.getChildren()) {
                float chy;
                float cmy;
                Anchor anchor = child.getAnchor();
                float chx = anchor.xTransform.apply(component, Float.valueOf(child.getX())).floatValue();
                float cmx = mx - chx;
                if (!this.clickRecursively(child, cmx, cmy = my - (chy = anchor.yTransform.apply(component, Float.valueOf(child.getY())).floatValue()), button)) continue;
                return true;
            }
            if (component.mouseClicked(mx, my, button)) {
                if (this.focused != null && this.focused != component) {
                    this.focused.setFocused(false);
                }
                component.setFocused(true);
                this.focused = component;
                return true;
            }
            return false;
        }
        return false;
    }

    public void mouseMoved(double mx, double my) {
        if (this.focused != null) {
            float accumulatedX = 0.0f;
            float accumulatedY = 0.0f;
            for (FDScreenComponent component = this.focused; component != null; component = component.getParent()) {
                accumulatedX += component.getX();
                accumulatedY += component.getY();
            }
            this.focused.mouseMoved(mx - (double)accumulatedX, my - (double)accumulatedY);
        }
    }

    public boolean mouseDragged(double mx, double my, int button, double leftRight, double upDown) {
        if (this.focused != null && this.focused.getParent() != null) {
            Anchor anchor = this.focused.getAnchor();
            float cmx = anchor.xTransform.apply(this.focused.getParent(), Float.valueOf(this.focused.getX())).floatValue();
            float cmy = anchor.yTransform.apply(this.focused.getParent(), Float.valueOf(this.focused.getY())).floatValue();
            for (FDScreenComponent parent = this.focused.getParent(); parent != null && parent.getParent() != null; parent = parent.getParent()) {
                anchor = parent.getAnchor();
                float acmx = anchor.xTransform.apply(parent.getParent(), Float.valueOf(parent.getX())).floatValue();
                float acmy = anchor.yTransform.apply(parent.getParent(), Float.valueOf(parent.getY())).floatValue();
                cmx += acmx;
                cmy += acmy;
            }
            float fmx = (float)(mx - (double)cmx);
            float fmy = (float)(my - (double)cmy);
            return this.focused.mouseDragged(fmx, fmy, button, leftRight, upDown);
        }
        return false;
    }

    public boolean mouseReleased(double mx, double my, int action) {
        if (this.focused != null && this.focused.getParent() != null) {
            Anchor anchor = this.focused.getAnchor();
            float cmx = anchor.xTransform.apply(this.focused.getParent(), Float.valueOf(this.focused.getX())).floatValue();
            float cmy = anchor.yTransform.apply(this.focused.getParent(), Float.valueOf(this.focused.getY())).floatValue();
            for (FDScreenComponent parent = this.focused.getParent(); parent != null && parent.getParent() != null; parent = parent.getParent()) {
                anchor = parent.getAnchor();
                float acmx = anchor.xTransform.apply(parent.getParent(), Float.valueOf(parent.getX())).floatValue();
                float acmy = anchor.yTransform.apply(parent.getParent(), Float.valueOf(parent.getY())).floatValue();
                cmx += acmx;
                cmy += acmy;
            }
            float fmx = (float)(mx - (double)cmx);
            float fmy = (float)(my - (double)cmy);
            return this.focused.mouseReleased(fmx, fmy, action);
        }
        return false;
    }

    public boolean mouseScrolled(double mx, double my, double xd, double yd) {
        for (FDScreenComponent component : this.screenLayers) {
            if (!this.scrollRecursively(component, (float)mx, (float)my, (float)xd, (float)yd)) continue;
            return true;
        }
        return false;
    }

    protected boolean scrollRecursively(FDScreenComponent component, float mx, float my, float xd, float yd) {
        for (FDScreenComponent child : component.getChildren()) {
            float chy;
            float cmy;
            Anchor anchor = child.getAnchor();
            float chx = anchor.xTransform.apply(component, Float.valueOf(child.getX())).floatValue();
            float cmx = mx - chx;
            if (!this.scrollRecursively(child, cmx, cmy = my - (chy = anchor.yTransform.apply(component, Float.valueOf(child.getY())).floatValue()), xd, yd)) continue;
            return true;
        }
        return component.isMouseOver(mx, my) && component.mouseScrolled(mx, my, xd, yd);
    }

    public boolean charTyped(char character, int button) {
        return this.focused != null && this.focused.charTyped(character, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.focused != null && this.focused.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        return this.focused != null && this.focused.keyReleased(keyCode, scanCode, modifiers);
    }

    public FDScreenComponent getComponentById(String uniqueId) {
        return this.componentLookup.get(uniqueId);
    }

    public void addComponent(FDScreenComponent component) {
        this.componentLookup.put(component.getUniqueId(), component);
        if (component.getParent() == null) {
            FDScreenComponent main = this.componentLookup.get("main");
            main.getChildren().setAsChild(component);
            component.setParent(main);
        }
    }

    public void removeComponent(String id) {
        FDScreenComponent component = this.getComponentById(id);
        if (component != null) {
            this.componentLookup.remove(id);
            FDScreenComponent parent = component.getParent();
            if (parent != null) {
                parent.getChildren().removeChild(id);
            }
        }
    }

    public List<FDScreenComponent> getScreenLayers() {
        return this.screenLayers;
    }
}

