/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.client.particles.stripe_particle;

import com.finderfeed.fdbosses.client.particles.stripe_particle.StripeParticleOptions;
import com.finderfeed.fdlib.systems.particle.FDParticleRenderType;
import com.finderfeed.fdlib.systems.shapes.FD2DShape;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import com.finderfeed.fdlib.util.rendering.renderers.ShapeOnCurveRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class StripeParticle
extends Particle {
    private StripeParticleOptions stripeParticleOptions;
    private List<Vector3f> points;
    private FD2DShape shape;
    public static final ParticleRenderType RENDER_TYPE = new FDParticleRenderType(){

        public void end() {
            RenderSystem.setShader(GameRenderer::getParticleShader);
            RenderSystem.defaultBlendFunc();
        }

        @Nullable
        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            if (Minecraft.useShaderTransparency()) {
                Minecraft.getInstance().levelRenderer.getParticlesTarget().bindWrite(false);
            } else {
                Minecraft.getInstance().getMainRenderTarget().bindWrite(false);
            }
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::getRendertypeLightningShader);
            RenderSystem.blendFunc((int)770, (int)1);
            RenderSystem.enableCull();
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        }
    };

    public StripeParticle(StripeParticleOptions options, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
        super(level, x, y, z, xd, yd, zd);
        this.stripeParticleOptions = options;
        this.x = x;
        this.y = y;
        this.z = z;
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.lifetime = options.getLifetime();
        this.shape = FD2DShape.createSimpleCircleNVertexShape((float)options.getScale(), (int)options.getShapeVertices());
        this.points = this.stripeParticleOptions.getOffsets().stream().map(v -> new Vector3f((float)v.x + 0.001f, (float)v.y + 0.001f, (float)v.z + 0.001f)).toList();
    }

    public AABB getRenderBoundingBox(float partialTicks) {
        return AABB.INFINITE;
    }

    public void render(VertexConsumer vertex, Camera camera, float pticks) {
        float lifetimeP = ((float)this.age + pticks) / (float)this.lifetime;
        float startP = FDMathUtil.lerp((float)(-this.stripeParticleOptions.getStripePercentLength()), (float)1.0f, (float)lifetimeP);
        float endP = startP + this.stripeParticleOptions.getStripePercentLength();
        Vec3 pos = FDMathUtil.interpolateVectors((Vec3)new Vec3(this.xo, this.yo, this.zo), (Vec3)new Vec3(this.x, this.y, this.z), (float)pticks).subtract(camera.getPosition());
        PoseStack matrix = new PoseStack();
        matrix.pushPose();
        matrix.translate(pos.x, pos.y, pos.z);
        ShapeOnCurveRenderer.start((VertexConsumer)vertex).scalingFunction(v -> {
            float distToEnd = endP - v.floatValue();
            float distToStart = v.floatValue() - startP;
            if (distToStart < 0.0f) {
                distToStart = 0.0f;
            }
            float p = distToEnd > distToStart ? distToStart / (this.stripeParticleOptions.getStripePercentLength() / 2.0f) : distToEnd / (this.stripeParticleOptions.getStripePercentLength() / 2.0f);
            float startp = Math.clamp(v.floatValue() / this.stripeParticleOptions.getStartInPercent(), 0.0f, 1.0f);
            float endp = Math.clamp((1.0f - v.floatValue()) / this.stripeParticleOptions.getEndOutPercent(), 0.0f, 1.0f);
            return Float.valueOf(Math.clamp(FDEasings.easeOut((float)p), 0.0f, 1.0f) * startp * endp);
        }).renderCount(2).startPercent(startP).endPercent(endP).pose(matrix).shape(this.shape).startColor(this.stripeParticleOptions.getStartColor()).endColor(this.stripeParticleOptions.getEndColor()).curvePositions(this.points).lod(Math.clamp((long)this.stripeParticleOptions.getLOD(), 0, 200)).render();
        matrix.popPose();
    }

    protected int getLightColor(float p_107249_) {
        return 0xF000F0;
    }

    public ParticleRenderType getRenderType() {
        return RENDER_TYPE;
    }

    public static class Factory
    implements ParticleProvider<StripeParticleOptions> {
        @Nullable
        public Particle createParticle(StripeParticleOptions options, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            return new StripeParticle(options, level, x, y, z, xd, yd, zd);
        }
    }
}

