/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_cannon;

import com.finderfeed.fdbosses.BossTargetFinder;
import com.finderfeed.fdbosses.BossUtil;
import com.finderfeed.fdbosses.client.BossParticles;
import com.finderfeed.fdbosses.client.particles.GravityParticleOptions;
import com.finderfeed.fdbosses.client.particles.smoke_particle.BigSmokeParticleOptions;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthAttackType;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthDamageSource;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthEntity;
import com.finderfeed.fdbosses.init.BossDamageSources;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdbosses.init.BossEntityDataSerializers;
import com.finderfeed.fdbosses.packets.SlamParticlesPacket;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.util.FDProjectile;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticleOptions;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class MalkuthCannonProjectile
extends FDProjectile
implements AutoSerializable {
    public static final int PROJECITLE_INVULNERABILITY_TIME = 10;
    public static final EntityDataAccessor<MalkuthAttackType> MALKUTH_ATTACK_TYPE = SynchedEntityData.defineId(MalkuthCannonProjectile.class, (EntityDataSerializer)((EntityDataSerializer)BossEntityDataSerializers.MALKUTH_ATTACK_TYPE.get()));
    @SerializableField
    private MalkuthAttackType malkuthAttackType = MalkuthAttackType.FIRE;
    @SerializableField
    private int reversedAge = 3000;
    @SerializableField
    private float damage;

    public MalkuthCannonProjectile(EntityType<? extends AbstractHurtingProjectile> type, Level level) {
        super(type, level);
        this.setNoGravity(false);
    }

    public static MalkuthCannonProjectile summon(Level level, Vec3 pos, Vec3 speed, int lifetime, MalkuthAttackType projectileDamageType, float damage) {
        MalkuthCannonProjectile malkuthCannonProjectile = new MalkuthCannonProjectile(BossEntities.MALKUTH_CANNON_PROJECTILE.get(), level);
        malkuthCannonProjectile.setPos(pos);
        malkuthCannonProjectile.setDeltaMovement(speed);
        malkuthCannonProjectile.reversedAge = lifetime;
        malkuthCannonProjectile.setMalkuthAttackType(projectileDamageType);
        malkuthCannonProjectile.damage = damage;
        level.addFreshEntity((Entity)malkuthCannonProjectile);
        return malkuthCannonProjectile;
    }

    public void setMalkuthAttackType(MalkuthAttackType malkuthAttackType) {
        this.malkuthAttackType = malkuthAttackType;
        this.entityData.set(MALKUTH_ATTACK_TYPE, (Object)malkuthAttackType);
    }

    public MalkuthAttackType getMalkuthAttackType() {
        return (MalkuthAttackType)((Object)this.entityData.get(MALKUTH_ATTACK_TYPE));
    }

    public void tick() {
        if (!this.level().isClientSide) {
            this.setMalkuthAttackType(this.malkuthAttackType);
            this.applyGravity();
            if (this.reversedAge-- <= 0) {
                this.explode(this.position());
            }
        }
        super.tick();
        if (this.level().isClientSide) {
            this.spawnParticles();
        }
    }

    private void spawnParticles() {
        Vec3 between = new Vec3(this.xo - this.getX(), this.yo - this.getY(), this.zo - this.getZ());
        float dist = (float)between.length();
        between = between.normalize();
        for (float i = 0.0f; i <= dist; i += 0.5f) {
            float p = i / dist;
            for (int count = 0; count < 4; ++count) {
                float b;
                float g;
                float r;
                if (this.getMalkuthAttackType().isFire()) {
                    r = 0.8f + this.random.nextFloat() * 0.2f;
                    g = 0.3f + this.random.nextFloat() * 0.5f;
                    b = 0.1f + this.random.nextFloat() * 0.05f;
                } else {
                    r = 0.1f + this.random.nextFloat() * 0.05f;
                    g = 0.8f - this.random.nextFloat() * 0.3f;
                    b = 0.8f + this.random.nextFloat() * 0.2f;
                }
                Object options = (double)this.random.nextFloat() > 0.5 ? BallParticleOptions.builder().size(0.15f + this.random.nextFloat() * 0.1f).color(r, g, b).scalingOptions(0, 0, 10).build() : (this.getMalkuthAttackType().isFire() ? ParticleTypes.SMOKE : new GravityParticleOptions(BossParticles.ICE_CHUNK.get(), 10, 0.25f, 0.0f, 5.0f, true));
                this.level().addParticle((ParticleOptions)options, true, this.getX() + between.x * 1.5 + between.x * (double)p + (double)this.random.nextFloat() - 0.5, this.getY() + between.y * 1.5 + between.y * (double)p + (double)this.random.nextFloat() - 0.5, this.getZ() + between.z * 1.5 + between.z * (double)p + (double)this.random.nextFloat() - 0.5, 0.0, 0.0, 0.0);
            }
            float c = this.random.nextFloat() * 0.4f + 0.2f;
            BigSmokeParticleOptions bigSmokeParticleOptions = BigSmokeParticleOptions.builder().color(c, c, c).lifetime(0, 0, 10).size(1.0f + 0.1f * this.random.nextFloat()).build();
            this.level().addParticle((ParticleOptions)bigSmokeParticleOptions, true, this.getX() + between.x * (double)p + between.x, this.getY() + between.y * (double)p + between.y, this.getZ() + between.z * (double)p + between.z, 0.0, 0.0, 0.0);
        }
    }

    protected void onHitBlock(BlockHitResult res) {
        super.onHitBlock(res);
        if (!this.level().isClientSide && this.tickCount > 10) {
            this.explode(res.getLocation());
        }
    }

    protected void onHitEntity(EntityHitResult res) {
        super.onHitEntity(res);
        if (!this.level().isClientSide && this.tickCount > 10) {
            this.explode(res.getLocation());
        }
    }

    private void explode(Vec3 pos) {
        if (!this.level().isClientSide) {
            float c = this.random.nextFloat() * 0.2f + 0.2f;
            BigSmokeParticleOptions bigSmokeParticleOptions = BigSmokeParticleOptions.builder().color(c, c, c).lifetime(0, 0, 10).size(1.0f + 0.1f * this.random.nextFloat()).friction(0.7f).build();
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)bigSmokeParticleOptions, pos.x, pos.y, pos.z, 20, 0.0, 0.0, 0.0, 0.25);
            SlamParticlesPacket packet = new SlamParticlesPacket(new SlamParticlesPacket.SlamData(new BlockPos((int)pos.x, (int)pos.y, (int)pos.z), pos.add(0.0, 0.0, 0.0), new Vec3(1.0, 0.0, 0.0)).maxAngle((float)Math.PI * 2).maxSpeed(0.3f).collectRadius(2).maxParticleLifetime(30).count(20).maxVerticalSpeedEdges(0.15f).maxVerticalSpeedCenter(0.15f));
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            BossUtil.malkuthFireballExplosionParticles((ServerLevel)this.level(), pos, this.getMalkuthAttackType());
            List<LivingEntity> targets = BossTargetFinder.getEntitiesInSphere(LivingEntity.class, this.level(), pos, 2.5f, target -> !(target instanceof MalkuthEntity));
            List<MalkuthEntity> malkuth = BossTargetFinder.getEntitiesInSphere(MalkuthEntity.class, this.level(), pos, 10.0f);
            for (MalkuthEntity m : malkuth) {
                m.hurtBoss(1);
            }
            for (LivingEntity target2 : targets) {
                if (this.damage == 0.0f) continue;
                target2.hurt((DamageSource)new MalkuthDamageSource(BossDamageSources.MALKUTH_CANNONS_SOURCE, this.getMalkuthAttackType(), 100), this.damage);
            }
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.autoSave(tag);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.autoLoad(tag);
        this.setMalkuthAttackType(this.malkuthAttackType);
    }

    protected double getDefaultGravity() {
        return 0.08;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MALKUTH_ATTACK_TYPE, (Object)MalkuthAttackType.FIRE);
    }
}

