/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.init;

import com.finderfeed.fdbosses.FDBosses;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerStartedEvent;

@EventBusSubscriber(modid="fdbosses", bus=EventBusSubscriber.Bus.GAME)
public class BossDamageSources {
    public static final ResourceKey<DamageType> CHESED_ATTACK = BossDamageSources.key("chesed_attack");
    public static final ResourceKey<DamageType> CHESED_LOR_EASTER_EGG_ATTACK = BossDamageSources.key("chesed_lor_attack");
    public static final ResourceKey<DamageType> CHESED_BA_EASTER_EGG_ATTACK = BossDamageSources.key("chesed_ba_attack");
    public static final ResourceKey<DamageType> CHESED_ELECTRIC_SPHERE = BossDamageSources.key("electric_sphere");
    public static final ResourceKey<DamageType> CHESED_FALLING_BLOCK = BossDamageSources.key("chesed_falling_block");
    public static final ResourceKey<DamageType> CHESED_VERTICAL_RAY = BossDamageSources.key("chesed_vertical_ray");
    public static final ResourceKey<DamageType> CHESED_EARTHQUAKE = BossDamageSources.key("chesed_earthquake");
    public static final ResourceKey<DamageType> CHESED_ROLL = BossDamageSources.key("chesed_roll_attack");
    public static final ResourceKey<DamageType> CHESED_BLOCK_ATTACK = BossDamageSources.key("chesed_rock_attack");
    public static final ResourceKey<DamageType> MALKUTH_COWARDICE = BossDamageSources.key("malkuth_cowardice");
    public static final ResourceKey<DamageType> MALKUTH_CANNONS = BossDamageSources.key("malkuth_cannons");
    public static final ResourceKey<DamageType> MALKUTH_CHAINPUNCH = BossDamageSources.key("malkuth_chainpunch");
    public static final ResourceKey<DamageType> MALKUTH_EARTHSHATTER = BossDamageSources.key("malkuth_earthshatter");
    public static final ResourceKey<DamageType> MALKUTH_HELLSHAPER = BossDamageSources.key("malkuth_hellshaper");
    public static final ResourceKey<DamageType> MALKUTH_IMPALING_DOOM = BossDamageSources.key("malkuth_impaling_doom");
    public static final ResourceKey<DamageType> MALKUTH_SIDE_ROCKS = BossDamageSources.key("malkuth_side_rocks");
    public static final ResourceKey<DamageType> MALKUTH_SLASHES = BossDamageSources.key("malkuth_slashes");
    public static final ResourceKey<DamageType> MALKUTH_TSARS_WRATH = BossDamageSources.key("malkuth_tsars_wrath");
    private static EntityDamageSource CHESED_ATTACK_SOURCE;
    private static EntityDamageSource CHESED_LOR_ATTACK_SOURCE;
    private static EntityDamageSource CHESED_BA_ATTACK_SOURCE;
    public static DamageSource CHESED_ELECTRIC_SPHERE_SOURCE;
    public static DamageSource CHESED_FALLING_BLOCK_SOURCE;
    public static DamageSource CHESED_VERTICAL_RAY_SOURCE;
    public static DamageSource CHESED_EARTHQUAKE_SOURCE;
    public static DamageSource CHESED_ROLL_SOURCE;
    public static DamageSource CHESED_BLOCK_ATTACK_SOURCE;
    public static DamageSource MALKUTH_COWARDICE_SOURCE;
    public static DamageSource MALKUTH_CANNONS_SOURCE;
    public static DamageSource MALKUTH_CHAINPUNCH_SOURCE;
    public static DamageSource MALKUTH_EARTHSHATTER_SOURCE;
    public static DamageSource MALKUTH_HELLSHAPER_SOURCE;
    public static DamageSource MALKUTH_IMPALING_DOOM_SOURCE;
    public static DamageSource MALKUTH_SIDE_ROCKS_SOURCE;
    public static DamageSource MALKUTH_SLASHES_SOURCE;
    public static DamageSource MALKUTH_TSARS_WRATH_SOURCE;

    public static DamageSource chesedAttack(Entity attacker) {
        return CHESED_ATTACK_SOURCE.create(attacker);
    }

    public static DamageSource chesedLorAttack(Entity attacker) {
        return CHESED_LOR_ATTACK_SOURCE.create(attacker);
    }

    public static DamageSource chesedBaAttack(Entity attacker) {
        return CHESED_BA_ATTACK_SOURCE.create(attacker);
    }

    @SubscribeEvent
    public static void registerDamageTypes(ServerStartedEvent event) {
        RegistryAccess.Frozen access = event.getServer().registryAccess();
        CHESED_ATTACK_SOURCE = new EntityDamageSource((Holder<DamageType>)access.holderOrThrow(CHESED_ATTACK));
        CHESED_LOR_ATTACK_SOURCE = new EntityDamageSource((Holder<DamageType>)access.holderOrThrow(CHESED_LOR_EASTER_EGG_ATTACK));
        CHESED_BA_ATTACK_SOURCE = new EntityDamageSource((Holder<DamageType>)access.holderOrThrow(CHESED_BA_EASTER_EGG_ATTACK));
        CHESED_ELECTRIC_SPHERE_SOURCE = new DamageSource(access.holderOrThrow(CHESED_ELECTRIC_SPHERE));
        CHESED_FALLING_BLOCK_SOURCE = new DamageSource(access.holderOrThrow(CHESED_FALLING_BLOCK));
        CHESED_VERTICAL_RAY_SOURCE = new DamageSource(access.holderOrThrow(CHESED_VERTICAL_RAY));
        CHESED_EARTHQUAKE_SOURCE = new DamageSource(access.holderOrThrow(CHESED_EARTHQUAKE));
        CHESED_ROLL_SOURCE = new DamageSource(access.holderOrThrow(CHESED_ROLL));
        CHESED_BLOCK_ATTACK_SOURCE = new DamageSource(access.holderOrThrow(CHESED_BLOCK_ATTACK));
        MALKUTH_COWARDICE_SOURCE = new DamageSource(access.holderOrThrow(MALKUTH_COWARDICE));
        MALKUTH_CANNONS_SOURCE = new DamageSource(access.holderOrThrow(MALKUTH_CANNONS));
        MALKUTH_CHAINPUNCH_SOURCE = new DamageSource(access.holderOrThrow(MALKUTH_CHAINPUNCH));
        MALKUTH_HELLSHAPER_SOURCE = new DamageSource(access.holderOrThrow(MALKUTH_HELLSHAPER));
        MALKUTH_IMPALING_DOOM_SOURCE = new DamageSource(access.holderOrThrow(MALKUTH_IMPALING_DOOM));
        MALKUTH_SIDE_ROCKS_SOURCE = new DamageSource(access.holderOrThrow(MALKUTH_SIDE_ROCKS));
        MALKUTH_SLASHES_SOURCE = new DamageSource(access.holderOrThrow(MALKUTH_SLASHES));
        MALKUTH_TSARS_WRATH_SOURCE = new DamageSource(access.holderOrThrow(MALKUTH_TSARS_WRATH));
        MALKUTH_EARTHSHATTER_SOURCE = new DamageSource(access.holderOrThrow(MALKUTH_EARTHSHATTER));
    }

    private static ResourceKey<DamageType> key(String name) {
        return ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)FDBosses.location(name));
    }

    public static class EntityDamageSource {
        private Holder<DamageType> damageTypeHolder;

        public EntityDamageSource(Holder<DamageType> typeHolder) {
            this.damageTypeHolder = typeHolder;
        }

        public DamageSource create(Entity attacker) {
            return new DamageSource(this.damageTypeHolder, attacker);
        }
    }
}

