/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.init;

import com.finderfeed.fdlib.FDLib;
import com.finderfeed.fdlib.network.FDPacketHandler;
import com.finderfeed.fdlib.systems.FDRegistries;
import com.finderfeed.fdlib.systems.config.JsonConfig;
import com.finderfeed.fdlib.systems.config.packets.JsonConfigSyncPacket;
import com.finderfeed.fdlib.systems.config.packets.TriggerClientsideConfigReloadPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;

@Mod.EventBusSubscriber(modid="fdlib", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FDGameEvents {
    @SubscribeEvent
    public static void serverStartedEvent(ServerStartedEvent event) {
        FDLib.LOGGER.info("Loading FD configs...");
        for (JsonConfig config : FDRegistries.CONFIGS.get()) {
            config.loadFromDisk();
        }
        FDLib.LOGGER.info("Loaded FD configs.");
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            FDPacketHandler.INSTANCE.sendTo((Object)new JsonConfigSyncPacket(), player2.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            FDPacketHandler.INSTANCE.sendTo((Object)new TriggerClientsideConfigReloadPacket(false), player2.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }
}

