/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.init;

import com.finderfeed.fdlib.FDHelpers;
import com.finderfeed.fdlib.FDLib;
import com.finderfeed.fdlib.init.FDDefaultTagDeserializers;
import com.finderfeed.fdlib.nbt.FDTagDeserializers;
import com.finderfeed.fdlib.systems.FDRegistries;
import com.finderfeed.fdlib.systems.bedrock.animations.Animation;
import com.finderfeed.fdlib.systems.bedrock.models.FDModelInfo;
import com.finderfeed.fdlib.systems.config.JsonConfig;
import com.finderfeed.fdlib.systems.config.ReflectiveJsonConfig;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(modid="fdlib", bus=Mod.EventBusSubscriber.Bus.MOD)
public class FDModEvents {
    @SubscribeEvent
    public static void commonSetupEvent(FMLCommonSetupEvent event) {
        for (JsonConfig config : FDRegistries.CONFIGS.get()) {
            if (!(config instanceof ReflectiveJsonConfig)) continue;
            ReflectiveJsonConfig c = (ReflectiveJsonConfig)config;
            c.memorizeDefaultValues(c.getClass(), c);
        }
        event.enqueueWork(() -> {
            FDModEvents.loadAnimations();
            FDModEvents.loadModels();
            FDTagDeserializers.registerDeserializer(Vec3.class, FDDefaultTagDeserializers.VEC3);
        });
    }

    public static void loadAnimations() {
        FDLib.LOGGER.info("Loading FD animations...");
        for (Map.Entry entry : FDRegistries.ANIMATIONS.get().getEntries()) {
            ResourceKey key = (ResourceKey)entry.getKey();
            Animation value = (Animation)entry.getValue();
            ResourceLocation animationName = key.m_135782_();
            ResourceLocation location = value.getFileLocation();
            if (location == null) {
                throw new RuntimeException("The animation file location is not specified! Use Animation constructor with ResourceLocation which points to a file containing the animation!");
            }
            ResourceLocation actualLocation = ResourceLocation.m_214293_((String)location.m_135827_(), (String)("bedrock/animations/" + location.m_135815_()));
            FDLib.LOGGER.info("Loading animation: " + animationName);
            JsonElement json = FDHelpers.readJsonFileFromAssets(actualLocation);
            JsonObject object = json.getAsJsonObject();
            JsonObject animations = object.getAsJsonObject("animations");
            String path = animationName.m_135815_();
            if (!animations.has(path)) {
                throw new RuntimeException("Animation file " + location + " doesn't contain animation " + animationName);
            }
            value.load(animationName, animations.getAsJsonObject(path));
        }
        FDLib.LOGGER.info("FD Animations loaded!");
    }

    public static void loadModels() {
        FDLib.LOGGER.info("Loading FD models...");
        for (Map.Entry entry : FDRegistries.MODELS.get().getEntries()) {
            FDModelInfo value = (FDModelInfo)entry.getValue();
            ResourceLocation location = value.getModelName();
            ResourceLocation actualLocation = ResourceLocation.m_214293_((String)location.m_135827_(), (String)("bedrock/models/" + location.m_135815_()));
            FDLib.LOGGER.info("Loading model: " + location);
            JsonElement json = FDHelpers.readJsonFileFromAssets(actualLocation, ".geo.json");
            value.load(json.getAsJsonObject());
        }
        FDLib.LOGGER.info("FD Models loaded!");
    }
}

