/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.packets;

import com.finderfeed.fdlib.FDClientPacketExecutables;
import com.finderfeed.fdlib.network.FDPacket;
import com.finderfeed.fdlib.network.RegisterFDPacket;
import com.finderfeed.fdlib.systems.bedrock.animations.Animation;
import com.finderfeed.fdlib.systems.bedrock.animations.TransitionAnimation;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationTicker;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.TickerSyncInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

@RegisterFDPacket(value="fdlib:sync_entity_animations")
public class SyncEntityAnimationsPacket
extends FDPacket {
    private int entityId;
    private List<TickerSyncInstance> tickers;

    public SyncEntityAnimationsPacket(int entityId, Map<String, AnimationTicker> tickers) {
        this.entityId = entityId;
        this.tickers = new ArrayList<TickerSyncInstance>();
        for (Map.Entry<String, AnimationTicker> entry : tickers.entrySet()) {
            Animation animation = entry.getValue().getAnimation();
            if (animation.isToNullTransition()) continue;
            if (animation.isTransition()) {
                AnimationTicker ticker = new AnimationTicker(entry.getValue());
                ticker.setAnimation(((TransitionAnimation)animation).getTransitionTo());
                this.tickers.add(new TickerSyncInstance(entry.getKey(), ticker));
                continue;
            }
            this.tickers.add(new TickerSyncInstance(entry.getKey(), entry.getValue()));
        }
    }

    public SyncEntityAnimationsPacket(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.tickers = new ArrayList<TickerSyncInstance>();
        int length = buf.readInt();
        for (int i = 0; i < length; ++i) {
            this.tickers.add(new TickerSyncInstance(buf.m_130277_(), AnimationTicker.NETWORK_CODEC.fromNetwork(buf)));
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.tickers.size());
        for (TickerSyncInstance instance : this.tickers) {
            buf.m_130070_(instance.tickerName());
            AnimationTicker.NETWORK_CODEC.toNetwork(buf, instance.ticker());
        }
    }

    @Override
    public void clientAction(Supplier<NetworkEvent.Context> context) {
        FDClientPacketExecutables.entitySyncAnimationsPacket(this.entityId, this.tickers);
    }

    @Override
    public void serverAction(Supplier<NetworkEvent.Context> context) {
    }
}

