/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.bedrock.animations.animation_system.tile.renderer;

import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimatedObject;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationSystem;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.BoneTransformationController;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.tile.renderer.FDBlockEntityRenderLayer;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.tile.renderer.FDBlockRenderLayerOptions;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.tile.renderer.FDFreeBERenderer;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.tile.renderer.IBERenderOffScreen;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.tile.renderer.IShouldBERender;
import com.finderfeed.fdlib.systems.bedrock.models.FDModel;
import com.finderfeed.fdlib.systems.bedrock.models.FDModelPart;
import com.finderfeed.fdlib.util.FDColor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class FDBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private IShouldBERender<T> shouldBERender;
    private IBERenderOffScreen<T> renderOffScreen;
    private List<FDBlockEntityRenderLayer<T>> layers;
    private FDFreeBERenderer<T> freeRender;

    public FDBlockEntityRenderer(BlockEntityRendererProvider.Context ctx, IShouldBERender<T> shouldBERender, IBERenderOffScreen<T> shouldRenderOffScreen, List<FDBlockRenderLayerOptions<T>> layers, FDFreeBERenderer<T> freeRender) {
        this.freeRender = freeRender;
        this.shouldBERender = shouldBERender;
        this.renderOffScreen = shouldRenderOffScreen;
        this.layers = new ArrayList<FDBlockEntityRenderLayer<T>>();
        for (FDBlockRenderLayerOptions<T> layer : layers) {
            FDModel model = new FDModel(layer.layerModel.get());
            FDBlockEntityRenderLayer l = new FDBlockEntityRenderLayer(model, layer.renderType, layer.renderCondition, layer.transform, layer.layerColor, layer.boneControllers, layer.light);
            this.layers.add(l);
        }
    }

    public void m_6922_(T blockEntity, float pticks, PoseStack matrices, MultiBufferSource src, int light, int overlay) {
        if (blockEntity.m_58904_() == null) {
            return;
        }
        matrices.m_85836_();
        matrices.m_85837_(0.5, 0.0, 0.5);
        this.applyAnimations(blockEntity, pticks, matrices, src, light, overlay);
        this.renderLayers(blockEntity, pticks, matrices, src, light, overlay);
        if (this.freeRender != null) {
            this.freeRender.render(blockEntity, pticks, matrices, src, light, overlay);
        }
        matrices.m_85849_();
    }

    public void applyAnimations(T entity, float partialTicks, PoseStack matrices, MultiBufferSource src, int light, int overlay) {
        AnimationSystem system = ((AnimatedObject)entity).getAnimationSystem();
        if (system == null) {
            return;
        }
        for (FDBlockEntityRenderLayer<T> layer : this.layers) {
            FDModel model = layer.model();
            system.applyAnimations(model, partialTicks);
            for (Map.Entry<String, BoneTransformationController<T>> entry : layer.boneControllers().entrySet()) {
                FDModelPart modelPart = model.getModelPart(entry.getKey());
                if (modelPart == null) continue;
                BoneTransformationController<T> controller = entry.getValue();
                controller.transformBone(entity, model, modelPart, matrices, src, entry.getKey(), light, overlay, partialTicks);
            }
        }
    }

    public void renderLayers(T entity, float partialTicks, PoseStack matrices, MultiBufferSource src, int light, int overlay) {
        for (FDBlockEntityRenderLayer<T> layer : this.layers) {
            Function<T, Boolean> condition = layer.renderCondition();
            if (!condition.apply(entity).booleanValue()) continue;
            matrices.m_85836_();
            FDModel model = layer.model();
            RenderType type = layer.renderType().getValue(entity, partialTicks);
            VertexConsumer consumer = src.m_6299_(type);
            layer.matrixTransform().apply(entity, matrices, partialTicks);
            FDColor color = layer.color().getValue(entity, partialTicks);
            int l = light;
            if (layer.light() != -1) {
                l = layer.light();
            }
            model.render(matrices, consumer, l, overlay, color.r, color.g, color.b, color.a);
            matrices.m_85849_();
        }
    }

    public boolean m_142756_(T blockEntity, Vec3 idk) {
        return this.shouldBERender.shouldRender(blockEntity, idk);
    }

    public boolean m_5932_(T renderOffScreen) {
        return this.renderOffScreen.shouldRenderOffScreen(renderOffScreen);
    }
}

